package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{MillisecondDateTime, Integer, DateTime}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateSnapshotResponse(
    dataEncryptionKeyId: Option[String] = None,
    description: Option[String] = None,
    encrypted: Option[Boolean] = None,
    kmsKeyId: Option[String] = None,
    ownerId: Option[String] = None,
    progress: Option[String] = None,
    snapshotId: Option[String] = None,
    startTime: Option[DateTime] = None,
    state: Option[zio.aws.ec2.model.SnapshotState] = None,
    stateMessage: Option[String] = None,
    volumeId: Option[String] = None,
    volumeSize: Option[Integer] = None,
    ownerAlias: Option[String] = None,
    outpostArn: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    storageTier: Option[zio.aws.ec2.model.StorageTier] = None,
    restoreExpiryTime: Option[MillisecondDateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse = {
    import CreateSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse
      .builder()
      .optionallyWith(
        dataEncryptionKeyId.map(value => value: java.lang.String)
      )(_.dataEncryptionKeyId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateMessage.map(value => value: java.lang.String))(
        _.stateMessage
      )
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .optionallyWith(volumeSize.map(value => value: java.lang.Integer))(
        _.volumeSize
      )
      .optionallyWith(ownerAlias.map(value => value: java.lang.String))(
        _.ownerAlias
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(storageTier.map(value => value.unwrap))(_.storageTier)
      .optionallyWith(
        restoreExpiryTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.restoreExpiryTime)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateSnapshotResponse.ReadOnly =
    zio.aws.ec2.model.CreateSnapshotResponse.wrap(buildAwsValue())
}
object CreateSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateSnapshotResponse =
      zio.aws.ec2.model.CreateSnapshotResponse(
        dataEncryptionKeyId.map(value => value),
        description.map(value => value),
        encrypted.map(value => value),
        kmsKeyId.map(value => value),
        ownerId.map(value => value),
        progress.map(value => value),
        snapshotId.map(value => value),
        startTime.map(value => value),
        state.map(value => value),
        stateMessage.map(value => value),
        volumeId.map(value => value),
        volumeSize.map(value => value),
        ownerAlias.map(value => value),
        outpostArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        storageTier.map(value => value),
        restoreExpiryTime.map(value => value)
      )
    def dataEncryptionKeyId: Option[String]
    def description: Option[String]
    def encrypted: Option[Boolean]
    def kmsKeyId: Option[String]
    def ownerId: Option[String]
    def progress: Option[String]
    def snapshotId: Option[String]
    def startTime: Option[DateTime]
    def state: Option[zio.aws.ec2.model.SnapshotState]
    def stateMessage: Option[String]
    def volumeId: Option[String]
    def volumeSize: Option[Integer]
    def ownerAlias: Option[String]
    def outpostArn: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def storageTier: Option[zio.aws.ec2.model.StorageTier]
    def restoreExpiryTime: Option[MillisecondDateTime]
    def getDataEncryptionKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataEncryptionKeyId", dataEncryptionKeyId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.SnapshotState] =
      AwsError.unwrapOptionField("state", state)
    def getStateMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateMessage", stateMessage)
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getVolumeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getOwnerAlias: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAlias", ownerAlias)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStorageTier: ZIO[Any, AwsError, zio.aws.ec2.model.StorageTier] =
      AwsError.unwrapOptionField("storageTier", storageTier)
    def getRestoreExpiryTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("restoreExpiryTime", restoreExpiryTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse
  ) extends zio.aws.ec2.model.CreateSnapshotResponse.ReadOnly {
    override val dataEncryptionKeyId: Option[String] =
      scala.Option(impl.dataEncryptionKeyId()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val progress: Option[String] =
      scala.Option(impl.progress()).map(value => value: String)
    override val snapshotId: Option[String] =
      scala.Option(impl.snapshotId()).map(value => value: String)
    override val startTime: Option[DateTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val state: Option[zio.aws.ec2.model.SnapshotState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.SnapshotState.wrap(value))
    override val stateMessage: Option[String] =
      scala.Option(impl.stateMessage()).map(value => value: String)
    override val volumeId: Option[String] =
      scala.Option(impl.volumeId()).map(value => value: String)
    override val volumeSize: Option[Integer] =
      scala.Option(impl.volumeSize()).map(value => value: Integer)
    override val ownerAlias: Option[String] =
      scala.Option(impl.ownerAlias()).map(value => value: String)
    override val outpostArn: Option[String] =
      scala.Option(impl.outpostArn()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val storageTier: Option[zio.aws.ec2.model.StorageTier] = scala
      .Option(impl.storageTier())
      .map(value => zio.aws.ec2.model.StorageTier.wrap(value))
    override val restoreExpiryTime: Option[MillisecondDateTime] = scala
      .Option(impl.restoreExpiryTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse
  ): zio.aws.ec2.model.CreateSnapshotResponse.ReadOnly = new Wrapper(impl)
}
