package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AvailabilityZoneMessage(message: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessage = {
    import AvailabilityZoneMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessage
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AvailabilityZoneMessage.ReadOnly =
    zio.aws.ec2.model.AvailabilityZoneMessage.wrap(buildAwsValue())
}
object AvailabilityZoneMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AvailabilityZoneMessage =
      zio.aws.ec2.model.AvailabilityZoneMessage(message.map(value => value))
    def message: Option[String]
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessage
  ) extends zio.aws.ec2.model.AvailabilityZoneMessage.ReadOnly {
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessage
  ): zio.aws.ec2.model.AvailabilityZoneMessage.ReadOnly = new Wrapper(impl)
}
