package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{NetworkInterfaceId, InstanceId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AttachNetworkInterfaceRequest(
    deviceIndex: Integer,
    instanceId: InstanceId,
    networkInterfaceId: NetworkInterfaceId,
    networkCardIndex: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest = {
    import AttachNetworkInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest
      .builder()
      .deviceIndex(deviceIndex: java.lang.Integer)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .optionallyWith(networkCardIndex.map(value => value: java.lang.Integer))(
        _.networkCardIndex
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AttachNetworkInterfaceRequest.ReadOnly =
    zio.aws.ec2.model.AttachNetworkInterfaceRequest.wrap(buildAwsValue())
}
object AttachNetworkInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AttachNetworkInterfaceRequest =
      zio.aws.ec2.model.AttachNetworkInterfaceRequest(
        deviceIndex,
        instanceId,
        networkInterfaceId,
        networkCardIndex.map(value => value)
      )
    def deviceIndex: Integer
    def instanceId: InstanceId
    def networkInterfaceId: NetworkInterfaceId
    def networkCardIndex: Option[Integer]
    def getDeviceIndex: ZIO[Any, Nothing, Integer] = ZIO.succeed(deviceIndex)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
    def getNetworkCardIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("networkCardIndex", networkCardIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest
  ) extends zio.aws.ec2.model.AttachNetworkInterfaceRequest.ReadOnly {
    override val deviceIndex: Integer = impl.deviceIndex(): Integer
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId(impl.networkInterfaceId())
    override val networkCardIndex: Option[Integer] =
      scala.Option(impl.networkCardIndex()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest
  ): zio.aws.ec2.model.AttachNetworkInterfaceRequest.ReadOnly = new Wrapper(
    impl
  )
}
