package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AnalysisRouteTableRoute(
    destinationCidr: Option[String] = None,
    destinationPrefixListId: Option[String] = None,
    egressOnlyInternetGatewayId: Option[String] = None,
    gatewayId: Option[String] = None,
    instanceId: Option[String] = None,
    natGatewayId: Option[String] = None,
    networkInterfaceId: Option[String] = None,
    origin: Option[String] = None,
    transitGatewayId: Option[String] = None,
    vpcPeeringConnectionId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AnalysisRouteTableRoute = {
    import AnalysisRouteTableRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AnalysisRouteTableRoute
      .builder()
      .optionallyWith(destinationCidr.map(value => value: java.lang.String))(
        _.destinationCidr
      )
      .optionallyWith(
        destinationPrefixListId.map(value => value: java.lang.String)
      )(_.destinationPrefixListId)
      .optionallyWith(
        egressOnlyInternetGatewayId.map(value => value: java.lang.String)
      )(_.egressOnlyInternetGatewayId)
      .optionallyWith(gatewayId.map(value => value: java.lang.String))(
        _.gatewayId
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(natGatewayId.map(value => value: java.lang.String))(
        _.natGatewayId
      )
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(origin.map(value => value: java.lang.String))(_.origin)
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(
        vpcPeeringConnectionId.map(value => value: java.lang.String)
      )(_.vpcPeeringConnectionId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly =
    zio.aws.ec2.model.AnalysisRouteTableRoute.wrap(buildAwsValue())
}
object AnalysisRouteTableRoute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AnalysisRouteTableRoute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AnalysisRouteTableRoute =
      zio.aws.ec2.model.AnalysisRouteTableRoute(
        destinationCidr.map(value => value),
        destinationPrefixListId.map(value => value),
        egressOnlyInternetGatewayId.map(value => value),
        gatewayId.map(value => value),
        instanceId.map(value => value),
        natGatewayId.map(value => value),
        networkInterfaceId.map(value => value),
        origin.map(value => value),
        transitGatewayId.map(value => value),
        vpcPeeringConnectionId.map(value => value)
      )
    def destinationCidr: Option[String]
    def destinationPrefixListId: Option[String]
    def egressOnlyInternetGatewayId: Option[String]
    def gatewayId: Option[String]
    def instanceId: Option[String]
    def natGatewayId: Option[String]
    def networkInterfaceId: Option[String]
    def origin: Option[String]
    def transitGatewayId: Option[String]
    def vpcPeeringConnectionId: Option[String]
    def getDestinationCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidr", destinationCidr)
    def getDestinationPrefixListId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("destinationPrefixListId", destinationPrefixListId)
    def getEgressOnlyInternetGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "egressOnlyInternetGatewayId",
        egressOnlyInternetGatewayId
      )
    def getGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getNatGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("natGatewayId", natGatewayId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getOrigin: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("origin", origin)
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getVpcPeeringConnectionId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("vpcPeeringConnectionId", vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisRouteTableRoute
  ) extends zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly {
    override val destinationCidr: Option[String] =
      scala.Option(impl.destinationCidr()).map(value => value: String)
    override val destinationPrefixListId: Option[String] =
      scala.Option(impl.destinationPrefixListId()).map(value => value: String)
    override val egressOnlyInternetGatewayId: Option[String] = scala
      .Option(impl.egressOnlyInternetGatewayId())
      .map(value => value: String)
    override val gatewayId: Option[String] =
      scala.Option(impl.gatewayId()).map(value => value: String)
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val natGatewayId: Option[String] =
      scala.Option(impl.natGatewayId()).map(value => value: String)
    override val networkInterfaceId: Option[String] =
      scala.Option(impl.networkInterfaceId()).map(value => value: String)
    override val origin: Option[String] =
      scala.Option(impl.origin()).map(value => value: String)
    override val transitGatewayId: Option[String] =
      scala.Option(impl.transitGatewayId()).map(value => value: String)
    override val vpcPeeringConnectionId: Option[String] =
      scala.Option(impl.vpcPeeringConnectionId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisRouteTableRoute
  ): zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly = new Wrapper(impl)
}
