package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AdvertiseByoipCidrRequest(cidr: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrRequest = {
    import AdvertiseByoipCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrRequest
      .builder()
      .cidr(cidr: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AdvertiseByoipCidrRequest.ReadOnly =
    zio.aws.ec2.model.AdvertiseByoipCidrRequest.wrap(buildAwsValue())
}
object AdvertiseByoipCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AdvertiseByoipCidrRequest =
      zio.aws.ec2.model.AdvertiseByoipCidrRequest(cidr)
    def cidr: String
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrRequest
  ) extends zio.aws.ec2.model.AdvertiseByoipCidrRequest.ReadOnly {
    override val cidr: String = impl.cidr(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrRequest
  ): zio.aws.ec2.model.AdvertiseByoipCidrRequest.ReadOnly = new Wrapper(impl)
}
