package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UserIdGroupPair(
    description: Option[String] = None,
    groupId: Option[String] = None,
    groupName: Option[String] = None,
    peeringStatus: Option[String] = None,
    userId: Option[String] = None,
    vpcId: Option[String] = None,
    vpcPeeringConnectionId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.UserIdGroupPair = {
    import UserIdGroupPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.UserIdGroupPair
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(peeringStatus.map(value => value: java.lang.String))(
        _.peeringStatus
      )
      .optionallyWith(userId.map(value => value: java.lang.String))(_.userId)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        vpcPeeringConnectionId.map(value => value: java.lang.String)
      )(_.vpcPeeringConnectionId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.UserIdGroupPair.ReadOnly =
    zio.aws.ec2.model.UserIdGroupPair.wrap(buildAwsValue())
}
object UserIdGroupPair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.UserIdGroupPair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.UserIdGroupPair =
      zio.aws.ec2.model.UserIdGroupPair(
        description.map(value => value),
        groupId.map(value => value),
        groupName.map(value => value),
        peeringStatus.map(value => value),
        userId.map(value => value),
        vpcId.map(value => value),
        vpcPeeringConnectionId.map(value => value)
      )
    def description: Option[String]
    def groupId: Option[String]
    def groupName: Option[String]
    def peeringStatus: Option[String]
    def userId: Option[String]
    def vpcId: Option[String]
    def vpcPeeringConnectionId: Option[String]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getPeeringStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("peeringStatus", peeringStatus)
    def getUserId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userId", userId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getVpcPeeringConnectionId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("vpcPeeringConnectionId", vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.UserIdGroupPair
  ) extends zio.aws.ec2.model.UserIdGroupPair.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val groupId: Option[String] =
      scala.Option(impl.groupId()).map(value => value: String)
    override val groupName: Option[String] =
      scala.Option(impl.groupName()).map(value => value: String)
    override val peeringStatus: Option[String] =
      scala.Option(impl.peeringStatus()).map(value => value: String)
    override val userId: Option[String] =
      scala.Option(impl.userId()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val vpcPeeringConnectionId: Option[String] =
      scala.Option(impl.vpcPeeringConnectionId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.UserIdGroupPair
  ): zio.aws.ec2.model.UserIdGroupPair.ReadOnly = new Wrapper(impl)
}
