package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UserBucketDetails(
    s3Bucket: Option[String] = None,
    s3Key: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.UserBucketDetails = {
    import UserBucketDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.UserBucketDetails
      .builder()
      .optionallyWith(s3Bucket.map(value => value: java.lang.String))(
        _.s3Bucket
      )
      .optionallyWith(s3Key.map(value => value: java.lang.String))(_.s3Key)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.UserBucketDetails.ReadOnly =
    zio.aws.ec2.model.UserBucketDetails.wrap(buildAwsValue())
}
object UserBucketDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.UserBucketDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.UserBucketDetails =
      zio.aws.ec2.model.UserBucketDetails(
        s3Bucket.map(value => value),
        s3Key.map(value => value)
      )
    def s3Bucket: Option[String]
    def s3Key: Option[String]
    def getS3Bucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Key: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Key", s3Key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.UserBucketDetails
  ) extends zio.aws.ec2.model.UserBucketDetails.ReadOnly {
    override val s3Bucket: Option[String] =
      scala.Option(impl.s3Bucket()).map(value => value: String)
    override val s3Key: Option[String] =
      scala.Option(impl.s3Key()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.UserBucketDetails
  ): zio.aws.ec2.model.UserBucketDetails.ReadOnly = new Wrapper(impl)
}
