package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SecurityGroupName, SecurityGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateSecurityGroupRuleDescriptionsEgressRequest(
    groupId: Option[SecurityGroupId] = None,
    groupName: Option[SecurityGroupName] = None,
    ipPermissions: Option[Iterable[zio.aws.ec2.model.IpPermission]] = None,
    securityGroupRuleDescriptions: Option[
      Iterable[zio.aws.ec2.model.SecurityGroupRuleDescription]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest = {
    import UpdateSecurityGroupRuleDescriptionsEgressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest
      .builder()
      .optionallyWith(
        groupId.map(value => SecurityGroupId.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        groupName.map(value =>
          SecurityGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .optionallyWith(
        ipPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipPermissions)
      .optionallyWith(
        securityGroupRuleDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroupRuleDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest.ReadOnly =
    zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest
      .wrap(buildAwsValue())
}
object UpdateSecurityGroupRuleDescriptionsEgressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest =
      zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest(
        groupId.map(value => value),
        groupName.map(value => value),
        ipPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityGroupRuleDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def groupId: Option[SecurityGroupId]
    def groupName: Option[SecurityGroupName]
    def ipPermissions: Option[List[zio.aws.ec2.model.IpPermission.ReadOnly]]
    def securityGroupRuleDescriptions
        : Option[List[zio.aws.ec2.model.SecurityGroupRuleDescription.ReadOnly]]
    def getGroupId: ZIO[Any, AwsError, SecurityGroupId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, SecurityGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getIpPermissions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      AwsError.unwrapOptionField("ipPermissions", ipPermissions)
    def getSecurityGroupRuleDescriptions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SecurityGroupRuleDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "securityGroupRuleDescriptions",
      securityGroupRuleDescriptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest
  ) extends zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest.ReadOnly {
    override val groupId: Option[SecurityGroupId] = scala
      .Option(impl.groupId())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupId(value))
    override val groupName: Option[SecurityGroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupName(value))
    override val ipPermissions
        : Option[List[zio.aws.ec2.model.IpPermission.ReadOnly]] = scala
      .Option(impl.ipPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IpPermission.wrap(item)
        }.toList
      )
    override val securityGroupRuleDescriptions: Option[
      List[zio.aws.ec2.model.SecurityGroupRuleDescription.ReadOnly]
    ] = scala
      .Option(impl.securityGroupRuleDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SecurityGroupRuleDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest
  ): zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest.ReadOnly =
    new Wrapper(impl)
}
