package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  DateTime,
  TransitGatewayId,
  TransitGatewayAttachmentId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TransitGatewayConnect(
    transitGatewayAttachmentId: Option[TransitGatewayAttachmentId] = None,
    transportTransitGatewayAttachmentId: Option[TransitGatewayAttachmentId] =
      None,
    transitGatewayId: Option[TransitGatewayId] = None,
    state: Option[zio.aws.ec2.model.TransitGatewayAttachmentState] = None,
    creationTime: Option[DateTime] = None,
    options: Option[zio.aws.ec2.model.TransitGatewayConnectOptions] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayConnect = {
    import TransitGatewayConnect.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayConnect
      .builder()
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(
        transportTransitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transportTransitGatewayAttachmentId)
      .optionallyWith(
        transitGatewayId.map(value =>
          TransitGatewayId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayConnect.ReadOnly =
    zio.aws.ec2.model.TransitGatewayConnect.wrap(buildAwsValue())
}
object TransitGatewayConnect {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayConnect
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayConnect =
      zio.aws.ec2.model.TransitGatewayConnect(
        transitGatewayAttachmentId.map(value => value),
        transportTransitGatewayAttachmentId.map(value => value),
        transitGatewayId.map(value => value),
        state.map(value => value),
        creationTime.map(value => value),
        options.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayAttachmentId: Option[TransitGatewayAttachmentId]
    def transportTransitGatewayAttachmentId: Option[TransitGatewayAttachmentId]
    def transitGatewayId: Option[TransitGatewayId]
    def state: Option[zio.aws.ec2.model.TransitGatewayAttachmentState]
    def creationTime: Option[DateTime]
    def options: Option[zio.aws.ec2.model.TransitGatewayConnectOptions.ReadOnly]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getTransportTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transportTransitGatewayAttachmentId",
        transportTransitGatewayAttachmentId
      )
    def getTransitGatewayId: ZIO[Any, AwsError, TransitGatewayId] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayAttachmentState] =
      AwsError.unwrapOptionField("state", state)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayConnectOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayConnect
  ) extends zio.aws.ec2.model.TransitGatewayConnect.ReadOnly {
    override val transitGatewayAttachmentId
        : Option[TransitGatewayAttachmentId] = scala
      .Option(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val transportTransitGatewayAttachmentId
        : Option[TransitGatewayAttachmentId] = scala
      .Option(impl.transportTransitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val transitGatewayId: Option[TransitGatewayId] = scala
      .Option(impl.transitGatewayId())
      .map(value => zio.aws.ec2.model.primitives.TransitGatewayId(value))
    override val state
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.TransitGatewayAttachmentState.wrap(value))
    override val creationTime: Option[DateTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val options
        : Option[zio.aws.ec2.model.TransitGatewayConnectOptions.ReadOnly] =
      scala
        .Option(impl.options())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayConnectOptions.wrap(value)
        )
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayConnect
  ): zio.aws.ec2.model.TransitGatewayConnect.ReadOnly = new Wrapper(impl)
}
