package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TotalLocalStorageGBRequest(
    min: Option[Double] = None,
    max: Option[Double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TotalLocalStorageGBRequest = {
    import TotalLocalStorageGBRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TotalLocalStorageGBRequest
      .builder()
      .optionallyWith(min.map(value => value: java.lang.Double))(_.min)
      .optionallyWith(max.map(value => value: java.lang.Double))(_.max)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TotalLocalStorageGBRequest.ReadOnly =
    zio.aws.ec2.model.TotalLocalStorageGBRequest.wrap(buildAwsValue())
}
object TotalLocalStorageGBRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TotalLocalStorageGBRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TotalLocalStorageGBRequest =
      zio.aws.ec2.model.TotalLocalStorageGBRequest(
        min.map(value => value),
        max.map(value => value)
      )
    def min: Option[Double]
    def max: Option[Double]
    def getMin: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("min", min)
    def getMax: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("max", max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TotalLocalStorageGBRequest
  ) extends zio.aws.ec2.model.TotalLocalStorageGBRequest.ReadOnly {
    override val min: Option[Double] =
      scala.Option(impl.min()).map(value => value: Double)
    override val max: Option[Double] =
      scala.Option(impl.max()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TotalLocalStorageGBRequest
  ): zio.aws.ec2.model.TotalLocalStorageGBRequest.ReadOnly = new Wrapper(impl)
}
