package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SubnetCidrBlockState(
    state: Option[zio.aws.ec2.model.SubnetCidrBlockStateCode] = None,
    statusMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SubnetCidrBlockState = {
    import SubnetCidrBlockState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SubnetCidrBlockState
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SubnetCidrBlockState.ReadOnly =
    zio.aws.ec2.model.SubnetCidrBlockState.wrap(buildAwsValue())
}
object SubnetCidrBlockState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SubnetCidrBlockState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SubnetCidrBlockState =
      zio.aws.ec2.model.SubnetCidrBlockState(
        state.map(value => value),
        statusMessage.map(value => value)
      )
    def state: Option[zio.aws.ec2.model.SubnetCidrBlockStateCode]
    def statusMessage: Option[String]
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.SubnetCidrBlockStateCode] =
      AwsError.unwrapOptionField("state", state)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SubnetCidrBlockState
  ) extends zio.aws.ec2.model.SubnetCidrBlockState.ReadOnly {
    override val state: Option[zio.aws.ec2.model.SubnetCidrBlockStateCode] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.ec2.model.SubnetCidrBlockStateCode.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SubnetCidrBlockState
  ): zio.aws.ec2.model.SubnetCidrBlockState.ReadOnly = new Wrapper(impl)
}
