package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SecurityGroupReference(
    groupId: Option[String] = None,
    referencingVpcId: Option[String] = None,
    vpcPeeringConnectionId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SecurityGroupReference = {
    import SecurityGroupReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SecurityGroupReference
      .builder()
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .optionallyWith(referencingVpcId.map(value => value: java.lang.String))(
        _.referencingVpcId
      )
      .optionallyWith(
        vpcPeeringConnectionId.map(value => value: java.lang.String)
      )(_.vpcPeeringConnectionId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SecurityGroupReference.ReadOnly =
    zio.aws.ec2.model.SecurityGroupReference.wrap(buildAwsValue())
}
object SecurityGroupReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SecurityGroupReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SecurityGroupReference =
      zio.aws.ec2.model.SecurityGroupReference(
        groupId.map(value => value),
        referencingVpcId.map(value => value),
        vpcPeeringConnectionId.map(value => value)
      )
    def groupId: Option[String]
    def referencingVpcId: Option[String]
    def vpcPeeringConnectionId: Option[String]
    def getGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getReferencingVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("referencingVpcId", referencingVpcId)
    def getVpcPeeringConnectionId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("vpcPeeringConnectionId", vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupReference
  ) extends zio.aws.ec2.model.SecurityGroupReference.ReadOnly {
    override val groupId: Option[String] =
      scala.Option(impl.groupId()).map(value => value: String)
    override val referencingVpcId: Option[String] =
      scala.Option(impl.referencingVpcId()).map(value => value: String)
    override val vpcPeeringConnectionId: Option[String] =
      scala.Option(impl.vpcPeeringConnectionId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupReference
  ): zio.aws.ec2.model.SecurityGroupReference.ReadOnly = new Wrapper(impl)
}
