package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{DateTime, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ScheduledInstanceAvailability(
    availabilityZone: Option[String] = None,
    availableInstanceCount: Option[Integer] = None,
    firstSlotStartTime: Option[DateTime] = None,
    hourlyPrice: Option[String] = None,
    instanceType: Option[String] = None,
    maxTermDurationInDays: Option[Integer] = None,
    minTermDurationInDays: Option[Integer] = None,
    networkPlatform: Option[String] = None,
    platform: Option[String] = None,
    purchaseToken: Option[String] = None,
    recurrence: Option[zio.aws.ec2.model.ScheduledInstanceRecurrence] = None,
    slotDurationInHours: Option[Integer] = None,
    totalScheduledInstanceHours: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailability = {
    import ScheduledInstanceAvailability.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailability
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        availableInstanceCount.map(value => value: java.lang.Integer)
      )(_.availableInstanceCount)
      .optionallyWith(
        firstSlotStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.firstSlotStartTime)
      .optionallyWith(hourlyPrice.map(value => value: java.lang.String))(
        _.hourlyPrice
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(
        maxTermDurationInDays.map(value => value: java.lang.Integer)
      )(_.maxTermDurationInDays)
      .optionallyWith(
        minTermDurationInDays.map(value => value: java.lang.Integer)
      )(_.minTermDurationInDays)
      .optionallyWith(networkPlatform.map(value => value: java.lang.String))(
        _.networkPlatform
      )
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(purchaseToken.map(value => value: java.lang.String))(
        _.purchaseToken
      )
      .optionallyWith(recurrence.map(value => value.buildAwsValue()))(
        _.recurrence
      )
      .optionallyWith(
        slotDurationInHours.map(value => value: java.lang.Integer)
      )(_.slotDurationInHours)
      .optionallyWith(
        totalScheduledInstanceHours.map(value => value: java.lang.Integer)
      )(_.totalScheduledInstanceHours)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ScheduledInstanceAvailability.ReadOnly =
    zio.aws.ec2.model.ScheduledInstanceAvailability.wrap(buildAwsValue())
}
object ScheduledInstanceAvailability {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailability
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstanceAvailability =
      zio.aws.ec2.model.ScheduledInstanceAvailability(
        availabilityZone.map(value => value),
        availableInstanceCount.map(value => value),
        firstSlotStartTime.map(value => value),
        hourlyPrice.map(value => value),
        instanceType.map(value => value),
        maxTermDurationInDays.map(value => value),
        minTermDurationInDays.map(value => value),
        networkPlatform.map(value => value),
        platform.map(value => value),
        purchaseToken.map(value => value),
        recurrence.map(value => value.asEditable),
        slotDurationInHours.map(value => value),
        totalScheduledInstanceHours.map(value => value)
      )
    def availabilityZone: Option[String]
    def availableInstanceCount: Option[Integer]
    def firstSlotStartTime: Option[DateTime]
    def hourlyPrice: Option[String]
    def instanceType: Option[String]
    def maxTermDurationInDays: Option[Integer]
    def minTermDurationInDays: Option[Integer]
    def networkPlatform: Option[String]
    def platform: Option[String]
    def purchaseToken: Option[String]
    def recurrence
        : Option[zio.aws.ec2.model.ScheduledInstanceRecurrence.ReadOnly]
    def slotDurationInHours: Option[Integer]
    def totalScheduledInstanceHours: Option[Integer]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAvailableInstanceCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("availableInstanceCount", availableInstanceCount)
    def getFirstSlotStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("firstSlotStartTime", firstSlotStartTime)
    def getHourlyPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hourlyPrice", hourlyPrice)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getMaxTermDurationInDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxTermDurationInDays", maxTermDurationInDays)
    def getMinTermDurationInDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minTermDurationInDays", minTermDurationInDays)
    def getNetworkPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkPlatform", networkPlatform)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getPurchaseToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("purchaseToken", purchaseToken)
    def getRecurrence: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ScheduledInstanceRecurrence.ReadOnly
    ] = AwsError.unwrapOptionField("recurrence", recurrence)
    def getSlotDurationInHours: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("slotDurationInHours", slotDurationInHours)
    def getTotalScheduledInstanceHours: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "totalScheduledInstanceHours",
        totalScheduledInstanceHours
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailability
  ) extends zio.aws.ec2.model.ScheduledInstanceAvailability.ReadOnly {
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val availableInstanceCount: Option[Integer] =
      scala.Option(impl.availableInstanceCount()).map(value => value: Integer)
    override val firstSlotStartTime: Option[DateTime] = scala
      .Option(impl.firstSlotStartTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val hourlyPrice: Option[String] =
      scala.Option(impl.hourlyPrice()).map(value => value: String)
    override val instanceType: Option[String] =
      scala.Option(impl.instanceType()).map(value => value: String)
    override val maxTermDurationInDays: Option[Integer] =
      scala.Option(impl.maxTermDurationInDays()).map(value => value: Integer)
    override val minTermDurationInDays: Option[Integer] =
      scala.Option(impl.minTermDurationInDays()).map(value => value: Integer)
    override val networkPlatform: Option[String] =
      scala.Option(impl.networkPlatform()).map(value => value: String)
    override val platform: Option[String] =
      scala.Option(impl.platform()).map(value => value: String)
    override val purchaseToken: Option[String] =
      scala.Option(impl.purchaseToken()).map(value => value: String)
    override val recurrence
        : Option[zio.aws.ec2.model.ScheduledInstanceRecurrence.ReadOnly] = scala
      .Option(impl.recurrence())
      .map(value => zio.aws.ec2.model.ScheduledInstanceRecurrence.wrap(value))
    override val slotDurationInHours: Option[Integer] =
      scala.Option(impl.slotDurationInHours()).map(value => value: Integer)
    override val totalScheduledInstanceHours: Option[Integer] = scala
      .Option(impl.totalScheduledInstanceHours())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailability
  ): zio.aws.ec2.model.ScheduledInstanceAvailability.ReadOnly = new Wrapper(
    impl
  )
}
