package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PublicIpv4Pool(
    poolId: Option[String] = None,
    description: Option[String] = None,
    poolAddressRanges: Option[Iterable[zio.aws.ec2.model.PublicIpv4PoolRange]] =
      None,
    totalAddressCount: Option[Integer] = None,
    totalAvailableAddressCount: Option[Integer] = None,
    networkBorderGroup: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PublicIpv4Pool = {
    import PublicIpv4Pool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PublicIpv4Pool
      .builder()
      .optionallyWith(poolId.map(value => value: java.lang.String))(_.poolId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        poolAddressRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.poolAddressRanges)
      .optionallyWith(totalAddressCount.map(value => value: java.lang.Integer))(
        _.totalAddressCount
      )
      .optionallyWith(
        totalAvailableAddressCount.map(value => value: java.lang.Integer)
      )(_.totalAvailableAddressCount)
      .optionallyWith(networkBorderGroup.map(value => value: java.lang.String))(
        _.networkBorderGroup
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PublicIpv4Pool.ReadOnly =
    zio.aws.ec2.model.PublicIpv4Pool.wrap(buildAwsValue())
}
object PublicIpv4Pool {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PublicIpv4Pool
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PublicIpv4Pool =
      zio.aws.ec2.model.PublicIpv4Pool(
        poolId.map(value => value),
        description.map(value => value),
        poolAddressRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalAddressCount.map(value => value),
        totalAvailableAddressCount.map(value => value),
        networkBorderGroup.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def poolId: Option[String]
    def description: Option[String]
    def poolAddressRanges
        : Option[List[zio.aws.ec2.model.PublicIpv4PoolRange.ReadOnly]]
    def totalAddressCount: Option[Integer]
    def totalAvailableAddressCount: Option[Integer]
    def networkBorderGroup: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getPoolId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getPoolAddressRanges: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.PublicIpv4PoolRange.ReadOnly
    ]] = AwsError.unwrapOptionField("poolAddressRanges", poolAddressRanges)
    def getTotalAddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalAddressCount", totalAddressCount)
    def getTotalAvailableAddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "totalAvailableAddressCount",
        totalAvailableAddressCount
      )
    def getNetworkBorderGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkBorderGroup", networkBorderGroup)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PublicIpv4Pool
  ) extends zio.aws.ec2.model.PublicIpv4Pool.ReadOnly {
    override val poolId: Option[String] =
      scala.Option(impl.poolId()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val poolAddressRanges
        : Option[List[zio.aws.ec2.model.PublicIpv4PoolRange.ReadOnly]] = scala
      .Option(impl.poolAddressRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PublicIpv4PoolRange.wrap(item)
        }.toList
      )
    override val totalAddressCount: Option[Integer] =
      scala.Option(impl.totalAddressCount()).map(value => value: Integer)
    override val totalAvailableAddressCount: Option[Integer] = scala
      .Option(impl.totalAvailableAddressCount())
      .map(value => value: Integer)
    override val networkBorderGroup: Option[String] =
      scala.Option(impl.networkBorderGroup()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PublicIpv4Pool
  ): zio.aws.ec2.model.PublicIpv4Pool.ReadOnly = new Wrapper(impl)
}
