package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProductCode(
    productCodeId: Option[String] = None,
    productCodeType: Option[zio.aws.ec2.model.ProductCodeValues] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.ProductCode = {
    import ProductCode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ProductCode
      .builder()
      .optionallyWith(productCodeId.map(value => value: java.lang.String))(
        _.productCodeId
      )
      .optionallyWith(productCodeType.map(value => value.unwrap))(
        _.productCodeType
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ProductCode.ReadOnly =
    zio.aws.ec2.model.ProductCode.wrap(buildAwsValue())
}
object ProductCode {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.ProductCode] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ProductCode =
      zio.aws.ec2.model.ProductCode(
        productCodeId.map(value => value),
        productCodeType.map(value => value)
      )
    def productCodeId: Option[String]
    def productCodeType: Option[zio.aws.ec2.model.ProductCodeValues]
    def getProductCodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productCodeId", productCodeId)
    def getProductCodeType
        : ZIO[Any, AwsError, zio.aws.ec2.model.ProductCodeValues] =
      AwsError.unwrapOptionField("productCodeType", productCodeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ProductCode
  ) extends zio.aws.ec2.model.ProductCode.ReadOnly {
    override val productCodeId: Option[String] =
      scala.Option(impl.productCodeId()).map(value => value: String)
    override val productCodeType: Option[zio.aws.ec2.model.ProductCodeValues] =
      scala
        .Option(impl.productCodeType())
        .map(value => zio.aws.ec2.model.ProductCodeValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ProductCode
  ): zio.aws.ec2.model.ProductCode.ReadOnly = new Wrapper(impl)
}
