package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayRouteTableId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyTransitGatewayOptions(
    addTransitGatewayCidrBlocks: Option[Iterable[String]] = None,
    removeTransitGatewayCidrBlocks: Option[Iterable[String]] = None,
    vpnEcmpSupport: Option[zio.aws.ec2.model.VpnEcmpSupportValue] = None,
    dnsSupport: Option[zio.aws.ec2.model.DnsSupportValue] = None,
    autoAcceptSharedAttachments: Option[
      zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue
    ] = None,
    defaultRouteTableAssociation: Option[
      zio.aws.ec2.model.DefaultRouteTableAssociationValue
    ] = None,
    associationDefaultRouteTableId: Option[TransitGatewayRouteTableId] = None,
    defaultRouteTablePropagation: Option[
      zio.aws.ec2.model.DefaultRouteTablePropagationValue
    ] = None,
    propagationDefaultRouteTableId: Option[TransitGatewayRouteTableId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayOptions = {
    import ModifyTransitGatewayOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayOptions
      .builder()
      .optionallyWith(
        addTransitGatewayCidrBlocks.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.addTransitGatewayCidrBlocks)
      .optionallyWith(
        removeTransitGatewayCidrBlocks.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.removeTransitGatewayCidrBlocks)
      .optionallyWith(vpnEcmpSupport.map(value => value.unwrap))(
        _.vpnEcmpSupport
      )
      .optionallyWith(dnsSupport.map(value => value.unwrap))(_.dnsSupport)
      .optionallyWith(autoAcceptSharedAttachments.map(value => value.unwrap))(
        _.autoAcceptSharedAttachments
      )
      .optionallyWith(defaultRouteTableAssociation.map(value => value.unwrap))(
        _.defaultRouteTableAssociation
      )
      .optionallyWith(
        associationDefaultRouteTableId.map(value =>
          TransitGatewayRouteTableId.unwrap(value): java.lang.String
        )
      )(_.associationDefaultRouteTableId)
      .optionallyWith(defaultRouteTablePropagation.map(value => value.unwrap))(
        _.defaultRouteTablePropagation
      )
      .optionallyWith(
        propagationDefaultRouteTableId.map(value =>
          TransitGatewayRouteTableId.unwrap(value): java.lang.String
        )
      )(_.propagationDefaultRouteTableId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyTransitGatewayOptions.ReadOnly =
    zio.aws.ec2.model.ModifyTransitGatewayOptions.wrap(buildAwsValue())
}
object ModifyTransitGatewayOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyTransitGatewayOptions =
      zio.aws.ec2.model.ModifyTransitGatewayOptions(
        addTransitGatewayCidrBlocks.map(value => value),
        removeTransitGatewayCidrBlocks.map(value => value),
        vpnEcmpSupport.map(value => value),
        dnsSupport.map(value => value),
        autoAcceptSharedAttachments.map(value => value),
        defaultRouteTableAssociation.map(value => value),
        associationDefaultRouteTableId.map(value => value),
        defaultRouteTablePropagation.map(value => value),
        propagationDefaultRouteTableId.map(value => value)
      )
    def addTransitGatewayCidrBlocks: Option[List[String]]
    def removeTransitGatewayCidrBlocks: Option[List[String]]
    def vpnEcmpSupport: Option[zio.aws.ec2.model.VpnEcmpSupportValue]
    def dnsSupport: Option[zio.aws.ec2.model.DnsSupportValue]
    def autoAcceptSharedAttachments
        : Option[zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue]
    def defaultRouteTableAssociation
        : Option[zio.aws.ec2.model.DefaultRouteTableAssociationValue]
    def associationDefaultRouteTableId: Option[TransitGatewayRouteTableId]
    def defaultRouteTablePropagation
        : Option[zio.aws.ec2.model.DefaultRouteTablePropagationValue]
    def propagationDefaultRouteTableId: Option[TransitGatewayRouteTableId]
    def getAddTransitGatewayCidrBlocks: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "addTransitGatewayCidrBlocks",
        addTransitGatewayCidrBlocks
      )
    def getRemoveTransitGatewayCidrBlocks: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "removeTransitGatewayCidrBlocks",
        removeTransitGatewayCidrBlocks
      )
    def getVpnEcmpSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpnEcmpSupportValue] =
      AwsError.unwrapOptionField("vpnEcmpSupport", vpnEcmpSupport)
    def getDnsSupport: ZIO[Any, AwsError, zio.aws.ec2.model.DnsSupportValue] =
      AwsError.unwrapOptionField("dnsSupport", dnsSupport)
    def getAutoAcceptSharedAttachments: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue
    ] = AwsError.unwrapOptionField(
      "autoAcceptSharedAttachments",
      autoAcceptSharedAttachments
    )
    def getDefaultRouteTableAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DefaultRouteTableAssociationValue
    ] = AwsError.unwrapOptionField(
      "defaultRouteTableAssociation",
      defaultRouteTableAssociation
    )
    def getAssociationDefaultRouteTableId
        : ZIO[Any, AwsError, TransitGatewayRouteTableId] =
      AwsError.unwrapOptionField(
        "associationDefaultRouteTableId",
        associationDefaultRouteTableId
      )
    def getDefaultRouteTablePropagation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DefaultRouteTablePropagationValue
    ] = AwsError.unwrapOptionField(
      "defaultRouteTablePropagation",
      defaultRouteTablePropagation
    )
    def getPropagationDefaultRouteTableId
        : ZIO[Any, AwsError, TransitGatewayRouteTableId] =
      AwsError.unwrapOptionField(
        "propagationDefaultRouteTableId",
        propagationDefaultRouteTableId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayOptions
  ) extends zio.aws.ec2.model.ModifyTransitGatewayOptions.ReadOnly {
    override val addTransitGatewayCidrBlocks: Option[List[String]] = scala
      .Option(impl.addTransitGatewayCidrBlocks())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val removeTransitGatewayCidrBlocks: Option[List[String]] = scala
      .Option(impl.removeTransitGatewayCidrBlocks())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val vpnEcmpSupport: Option[zio.aws.ec2.model.VpnEcmpSupportValue] =
      scala
        .Option(impl.vpnEcmpSupport())
        .map(value => zio.aws.ec2.model.VpnEcmpSupportValue.wrap(value))
    override val dnsSupport: Option[zio.aws.ec2.model.DnsSupportValue] = scala
      .Option(impl.dnsSupport())
      .map(value => zio.aws.ec2.model.DnsSupportValue.wrap(value))
    override val autoAcceptSharedAttachments
        : Option[zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue] = scala
      .Option(impl.autoAcceptSharedAttachments())
      .map(value =>
        zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue.wrap(value)
      )
    override val defaultRouteTableAssociation
        : Option[zio.aws.ec2.model.DefaultRouteTableAssociationValue] = scala
      .Option(impl.defaultRouteTableAssociation())
      .map(value =>
        zio.aws.ec2.model.DefaultRouteTableAssociationValue.wrap(value)
      )
    override val associationDefaultRouteTableId
        : Option[TransitGatewayRouteTableId] = scala
      .Option(impl.associationDefaultRouteTableId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayRouteTableId(value)
      )
    override val defaultRouteTablePropagation
        : Option[zio.aws.ec2.model.DefaultRouteTablePropagationValue] = scala
      .Option(impl.defaultRouteTablePropagation())
      .map(value =>
        zio.aws.ec2.model.DefaultRouteTablePropagationValue.wrap(value)
      )
    override val propagationDefaultRouteTableId
        : Option[TransitGatewayRouteTableId] = scala
      .Option(impl.propagationDefaultRouteTableId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayRouteTableId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayOptions
  ): zio.aws.ec2.model.ModifyTransitGatewayOptions.ReadOnly = new Wrapper(impl)
}
