package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, TrafficMirrorFilterRuleId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyTrafficMirrorFilterRuleRequest(
    trafficMirrorFilterRuleId: TrafficMirrorFilterRuleId,
    trafficDirection: Option[zio.aws.ec2.model.TrafficDirection] = None,
    ruleNumber: Option[Integer] = None,
    ruleAction: Option[zio.aws.ec2.model.TrafficMirrorRuleAction] = None,
    destinationPortRange: Option[
      zio.aws.ec2.model.TrafficMirrorPortRangeRequest
    ] = None,
    sourcePortRange: Option[zio.aws.ec2.model.TrafficMirrorPortRangeRequest] =
      None,
    protocol: Option[Integer] = None,
    destinationCidrBlock: Option[String] = None,
    sourceCidrBlock: Option[String] = None,
    description: Option[String] = None,
    removeFields: Option[
      Iterable[zio.aws.ec2.model.TrafficMirrorFilterRuleField]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleRequest = {
    import ModifyTrafficMirrorFilterRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleRequest
      .builder()
      .trafficMirrorFilterRuleId(
        TrafficMirrorFilterRuleId.unwrap(
          trafficMirrorFilterRuleId
        ): java.lang.String
      )
      .optionallyWith(trafficDirection.map(value => value.unwrap))(
        _.trafficDirection
      )
      .optionallyWith(ruleNumber.map(value => value: java.lang.Integer))(
        _.ruleNumber
      )
      .optionallyWith(ruleAction.map(value => value.unwrap))(_.ruleAction)
      .optionallyWith(destinationPortRange.map(value => value.buildAwsValue()))(
        _.destinationPortRange
      )
      .optionallyWith(sourcePortRange.map(value => value.buildAwsValue()))(
        _.sourcePortRange
      )
      .optionallyWith(protocol.map(value => value: java.lang.Integer))(
        _.protocol
      )
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(sourceCidrBlock.map(value => value: java.lang.String))(
        _.sourceCidrBlock
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        removeFields.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.removeFieldsWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleRequest.ReadOnly =
    zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleRequest.wrap(buildAwsValue())
}
object ModifyTrafficMirrorFilterRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleRequest =
      zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleRequest(
        trafficMirrorFilterRuleId,
        trafficDirection.map(value => value),
        ruleNumber.map(value => value),
        ruleAction.map(value => value),
        destinationPortRange.map(value => value.asEditable),
        sourcePortRange.map(value => value.asEditable),
        protocol.map(value => value),
        destinationCidrBlock.map(value => value),
        sourceCidrBlock.map(value => value),
        description.map(value => value),
        removeFields.map(value => value)
      )
    def trafficMirrorFilterRuleId: TrafficMirrorFilterRuleId
    def trafficDirection: Option[zio.aws.ec2.model.TrafficDirection]
    def ruleNumber: Option[Integer]
    def ruleAction: Option[zio.aws.ec2.model.TrafficMirrorRuleAction]
    def destinationPortRange
        : Option[zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly]
    def sourcePortRange
        : Option[zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly]
    def protocol: Option[Integer]
    def destinationCidrBlock: Option[String]
    def sourceCidrBlock: Option[String]
    def description: Option[String]
    def removeFields
        : Option[List[zio.aws.ec2.model.TrafficMirrorFilterRuleField]]
    def getTrafficMirrorFilterRuleId
        : ZIO[Any, Nothing, TrafficMirrorFilterRuleId] =
      ZIO.succeed(trafficMirrorFilterRuleId)
    def getTrafficDirection
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrafficDirection] =
      AwsError.unwrapOptionField("trafficDirection", trafficDirection)
    def getRuleNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ruleNumber", ruleNumber)
    def getRuleAction
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrafficMirrorRuleAction] =
      AwsError.unwrapOptionField("ruleAction", ruleAction)
    def getDestinationPortRange: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly
    ] = AwsError.unwrapOptionField("destinationPortRange", destinationPortRange)
    def getSourcePortRange: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly
    ] = AwsError.unwrapOptionField("sourcePortRange", sourcePortRange)
    def getProtocol: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getSourceCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceCidrBlock", sourceCidrBlock)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getRemoveFields: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TrafficMirrorFilterRuleField
    ]] = AwsError.unwrapOptionField("removeFields", removeFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleRequest
  ) extends zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleRequest.ReadOnly {
    override val trafficMirrorFilterRuleId: TrafficMirrorFilterRuleId =
      zio.aws.ec2.model.primitives
        .TrafficMirrorFilterRuleId(impl.trafficMirrorFilterRuleId())
    override val trafficDirection: Option[zio.aws.ec2.model.TrafficDirection] =
      scala
        .Option(impl.trafficDirection())
        .map(value => zio.aws.ec2.model.TrafficDirection.wrap(value))
    override val ruleNumber: Option[Integer] =
      scala.Option(impl.ruleNumber()).map(value => value: Integer)
    override val ruleAction: Option[zio.aws.ec2.model.TrafficMirrorRuleAction] =
      scala
        .Option(impl.ruleAction())
        .map(value => zio.aws.ec2.model.TrafficMirrorRuleAction.wrap(value))
    override val destinationPortRange
        : Option[zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly] =
      scala
        .Option(impl.destinationPortRange())
        .map(value =>
          zio.aws.ec2.model.TrafficMirrorPortRangeRequest.wrap(value)
        )
    override val sourcePortRange
        : Option[zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly] =
      scala
        .Option(impl.sourcePortRange())
        .map(value =>
          zio.aws.ec2.model.TrafficMirrorPortRangeRequest.wrap(value)
        )
    override val protocol: Option[Integer] =
      scala.Option(impl.protocol()).map(value => value: Integer)
    override val destinationCidrBlock: Option[String] =
      scala.Option(impl.destinationCidrBlock()).map(value => value: String)
    override val sourceCidrBlock: Option[String] =
      scala.Option(impl.sourceCidrBlock()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val removeFields
        : Option[List[zio.aws.ec2.model.TrafficMirrorFilterRuleField]] = scala
      .Option(impl.removeFields())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TrafficMirrorFilterRuleField.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleRequest
  ): zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleRequest.ReadOnly =
    new Wrapper(impl)
}
