package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyEbsDefaultKmsKeyIdResponse(
    kmsKeyId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdResponse = {
    import ModifyEbsDefaultKmsKeyIdResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdResponse
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdResponse.ReadOnly =
    zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdResponse.wrap(buildAwsValue())
}
object ModifyEbsDefaultKmsKeyIdResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdResponse =
      zio.aws.ec2.model
        .ModifyEbsDefaultKmsKeyIdResponse(kmsKeyId.map(value => value))
    def kmsKeyId: Option[String]
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdResponse
  ) extends zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdResponse.ReadOnly {
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdResponse
  ): zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdResponse.ReadOnly = new Wrapper(
    impl
  )
}
