package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, ResourceArn, PrefixListResourceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ManagedPrefixList(
    prefixListId: Option[PrefixListResourceId] = None,
    addressFamily: Option[String] = None,
    state: Option[zio.aws.ec2.model.PrefixListState] = None,
    stateMessage: Option[String] = None,
    prefixListArn: Option[ResourceArn] = None,
    prefixListName: Option[String] = None,
    maxEntries: Option[Integer] = None,
    version: Option[Long] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    ownerId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ManagedPrefixList = {
    import ManagedPrefixList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ManagedPrefixList
      .builder()
      .optionallyWith(
        prefixListId.map(value =>
          PrefixListResourceId.unwrap(value): java.lang.String
        )
      )(_.prefixListId)
      .optionallyWith(addressFamily.map(value => value: java.lang.String))(
        _.addressFamily
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateMessage.map(value => value: java.lang.String))(
        _.stateMessage
      )
      .optionallyWith(
        prefixListArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.prefixListArn)
      .optionallyWith(prefixListName.map(value => value: java.lang.String))(
        _.prefixListName
      )
      .optionallyWith(maxEntries.map(value => value: java.lang.Integer))(
        _.maxEntries
      )
      .optionallyWith(version.map(value => value: java.lang.Long))(_.version)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ManagedPrefixList.ReadOnly =
    zio.aws.ec2.model.ManagedPrefixList.wrap(buildAwsValue())
}
object ManagedPrefixList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ManagedPrefixList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ManagedPrefixList =
      zio.aws.ec2.model.ManagedPrefixList(
        prefixListId.map(value => value),
        addressFamily.map(value => value),
        state.map(value => value),
        stateMessage.map(value => value),
        prefixListArn.map(value => value),
        prefixListName.map(value => value),
        maxEntries.map(value => value),
        version.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerId.map(value => value)
      )
    def prefixListId: Option[PrefixListResourceId]
    def addressFamily: Option[String]
    def state: Option[zio.aws.ec2.model.PrefixListState]
    def stateMessage: Option[String]
    def prefixListArn: Option[ResourceArn]
    def prefixListName: Option[String]
    def maxEntries: Option[Integer]
    def version: Option[Long]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def ownerId: Option[String]
    def getPrefixListId: ZIO[Any, AwsError, PrefixListResourceId] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getAddressFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addressFamily", addressFamily)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.PrefixListState] =
      AwsError.unwrapOptionField("state", state)
    def getStateMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateMessage", stateMessage)
    def getPrefixListArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("prefixListArn", prefixListArn)
    def getPrefixListName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefixListName", prefixListName)
    def getMaxEntries: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxEntries", maxEntries)
    def getVersion: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("version", version)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ManagedPrefixList
  ) extends zio.aws.ec2.model.ManagedPrefixList.ReadOnly {
    override val prefixListId: Option[PrefixListResourceId] = scala
      .Option(impl.prefixListId())
      .map(value => zio.aws.ec2.model.primitives.PrefixListResourceId(value))
    override val addressFamily: Option[String] =
      scala.Option(impl.addressFamily()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.PrefixListState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.PrefixListState.wrap(value))
    override val stateMessage: Option[String] =
      scala.Option(impl.stateMessage()).map(value => value: String)
    override val prefixListArn: Option[ResourceArn] = scala
      .Option(impl.prefixListArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val prefixListName: Option[String] =
      scala.Option(impl.prefixListName()).map(value => value: String)
    override val maxEntries: Option[Integer] =
      scala.Option(impl.maxEntries()).map(value => value: Integer)
    override val version: Option[Long] =
      scala.Option(impl.version()).map(value => value: Long)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ManagedPrefixList
  ): zio.aws.ec2.model.ManagedPrefixList.ReadOnly = new Wrapper(impl)
}
