package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ListingState {
  def unwrap: software.amazon.awssdk.services.ec2.model.ListingState
}
object ListingState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ListingState
  ): zio.aws.ec2.model.ListingState = value match {
    case software.amazon.awssdk.services.ec2.model.ListingState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ListingState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.ListingState.SOLD =>
      val r = sold
      r
    case software.amazon.awssdk.services.ec2.model.ListingState.CANCELLED =>
      val r = cancelled
      r
    case software.amazon.awssdk.services.ec2.model.ListingState.PENDING =>
      val r = pending
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ListingState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ListingState =
      software.amazon.awssdk.services.ec2.model.ListingState.UNKNOWN_TO_SDK_VERSION
  }
  case object available extends zio.aws.ec2.model.ListingState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ListingState =
      software.amazon.awssdk.services.ec2.model.ListingState.AVAILABLE
  }
  case object sold extends zio.aws.ec2.model.ListingState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ListingState =
      software.amazon.awssdk.services.ec2.model.ListingState.SOLD
  }
  case object cancelled extends zio.aws.ec2.model.ListingState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ListingState =
      software.amazon.awssdk.services.ec2.model.ListingState.CANCELLED
  }
  case object pending extends zio.aws.ec2.model.ListingState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ListingState =
      software.amazon.awssdk.services.ec2.model.ListingState.PENDING
  }
}
