package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplatePlacement(
    availabilityZone: Option[String] = None,
    affinity: Option[String] = None,
    groupName: Option[String] = None,
    hostId: Option[String] = None,
    tenancy: Option[zio.aws.ec2.model.Tenancy] = None,
    spreadDomain: Option[String] = None,
    hostResourceGroupArn: Option[String] = None,
    partitionNumber: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplatePlacement = {
    import LaunchTemplatePlacement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplatePlacement
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(affinity.map(value => value: java.lang.String))(
        _.affinity
      )
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(hostId.map(value => value: java.lang.String))(_.hostId)
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .optionallyWith(spreadDomain.map(value => value: java.lang.String))(
        _.spreadDomain
      )
      .optionallyWith(
        hostResourceGroupArn.map(value => value: java.lang.String)
      )(_.hostResourceGroupArn)
      .optionallyWith(partitionNumber.map(value => value: java.lang.Integer))(
        _.partitionNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchTemplatePlacement.ReadOnly =
    zio.aws.ec2.model.LaunchTemplatePlacement.wrap(buildAwsValue())
}
object LaunchTemplatePlacement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplatePlacement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplatePlacement =
      zio.aws.ec2.model.LaunchTemplatePlacement(
        availabilityZone.map(value => value),
        affinity.map(value => value),
        groupName.map(value => value),
        hostId.map(value => value),
        tenancy.map(value => value),
        spreadDomain.map(value => value),
        hostResourceGroupArn.map(value => value),
        partitionNumber.map(value => value)
      )
    def availabilityZone: Option[String]
    def affinity: Option[String]
    def groupName: Option[String]
    def hostId: Option[String]
    def tenancy: Option[zio.aws.ec2.model.Tenancy]
    def spreadDomain: Option[String]
    def hostResourceGroupArn: Option[String]
    def partitionNumber: Option[Integer]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAffinity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("affinity", affinity)
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getHostId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostId", hostId)
    def getTenancy: ZIO[Any, AwsError, zio.aws.ec2.model.Tenancy] =
      AwsError.unwrapOptionField("tenancy", tenancy)
    def getSpreadDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spreadDomain", spreadDomain)
    def getHostResourceGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostResourceGroupArn", hostResourceGroupArn)
    def getPartitionNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("partitionNumber", partitionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplatePlacement
  ) extends zio.aws.ec2.model.LaunchTemplatePlacement.ReadOnly {
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val affinity: Option[String] =
      scala.Option(impl.affinity()).map(value => value: String)
    override val groupName: Option[String] =
      scala.Option(impl.groupName()).map(value => value: String)
    override val hostId: Option[String] =
      scala.Option(impl.hostId()).map(value => value: String)
    override val tenancy: Option[zio.aws.ec2.model.Tenancy] = scala
      .Option(impl.tenancy())
      .map(value => zio.aws.ec2.model.Tenancy.wrap(value))
    override val spreadDomain: Option[String] =
      scala.Option(impl.spreadDomain()).map(value => value: String)
    override val hostResourceGroupArn: Option[String] =
      scala.Option(impl.hostResourceGroupArn()).map(value => value: String)
    override val partitionNumber: Option[Integer] =
      scala.Option(impl.partitionNumber()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplatePlacement
  ): zio.aws.ec2.model.LaunchTemplatePlacement.ReadOnly = new Wrapper(impl)
}
