package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.LaunchTemplateElasticInferenceAcceleratorCount
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateElasticInferenceAccelerator(
    `type`: String,
    count: Option[LaunchTemplateElasticInferenceAcceleratorCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAccelerator = {
    import LaunchTemplateElasticInferenceAccelerator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAccelerator
      .builder()
      .`type`(`type`: java.lang.String)
      .optionallyWith(
        count.map(value =>
          LaunchTemplateElasticInferenceAcceleratorCount.unwrap(value): Integer
        )
      )(_.count)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator
      .wrap(buildAwsValue())
}
object LaunchTemplateElasticInferenceAccelerator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAccelerator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator =
      zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator(
        `type`,
        count.map(value => value)
      )
    def `type`: String
    def count: Option[LaunchTemplateElasticInferenceAcceleratorCount]
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
    def getCount
        : ZIO[Any, AwsError, LaunchTemplateElasticInferenceAcceleratorCount] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAccelerator
  ) extends zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator.ReadOnly {
    override val `type`: String = impl.`type`(): String
    override val count: Option[LaunchTemplateElasticInferenceAcceleratorCount] =
      scala
        .Option(impl.count())
        .map(value =>
          zio.aws.ec2.model.primitives
            .LaunchTemplateElasticInferenceAcceleratorCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAccelerator
  ): zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator.ReadOnly =
    new Wrapper(impl)
}
