package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  IpamNetmaskLength,
  Integer,
  ResourceArn,
  IpamPoolId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IpamPool(
    ownerId: Option[String] = None,
    ipamPoolId: Option[IpamPoolId] = None,
    sourceIpamPoolId: Option[IpamPoolId] = None,
    ipamPoolArn: Option[ResourceArn] = None,
    ipamScopeArn: Option[ResourceArn] = None,
    ipamScopeType: Option[zio.aws.ec2.model.IpamScopeType] = None,
    ipamArn: Option[ResourceArn] = None,
    ipamRegion: Option[String] = None,
    locale: Option[String] = None,
    poolDepth: Option[Integer] = None,
    state: Option[zio.aws.ec2.model.IpamPoolState] = None,
    stateMessage: Option[String] = None,
    description: Option[String] = None,
    autoImport: Option[Boolean] = None,
    publiclyAdvertisable: Option[Boolean] = None,
    addressFamily: Option[zio.aws.ec2.model.AddressFamily] = None,
    allocationMinNetmaskLength: Option[IpamNetmaskLength] = None,
    allocationMaxNetmaskLength: Option[IpamNetmaskLength] = None,
    allocationDefaultNetmaskLength: Option[IpamNetmaskLength] = None,
    allocationResourceTags: Option[
      Iterable[zio.aws.ec2.model.IpamResourceTag]
    ] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    awsService: Option[zio.aws.ec2.model.IpamPoolAwsService] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.IpamPool = {
    import IpamPool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamPool
      .builder()
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        ipamPoolId.map(value => IpamPoolId.unwrap(value): java.lang.String)
      )(_.ipamPoolId)
      .optionallyWith(
        sourceIpamPoolId.map(value =>
          IpamPoolId.unwrap(value): java.lang.String
        )
      )(_.sourceIpamPoolId)
      .optionallyWith(
        ipamPoolArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ipamPoolArn)
      .optionallyWith(
        ipamScopeArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ipamScopeArn)
      .optionallyWith(ipamScopeType.map(value => value.unwrap))(_.ipamScopeType)
      .optionallyWith(
        ipamArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ipamArn)
      .optionallyWith(ipamRegion.map(value => value: java.lang.String))(
        _.ipamRegion
      )
      .optionallyWith(locale.map(value => value: java.lang.String))(_.locale)
      .optionallyWith(poolDepth.map(value => value: java.lang.Integer))(
        _.poolDepth
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateMessage.map(value => value: java.lang.String))(
        _.stateMessage
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(autoImport.map(value => value: java.lang.Boolean))(
        _.autoImport
      )
      .optionallyWith(
        publiclyAdvertisable.map(value => value: java.lang.Boolean)
      )(_.publiclyAdvertisable)
      .optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily)
      .optionallyWith(
        allocationMinNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): java.lang.Integer
        )
      )(_.allocationMinNetmaskLength)
      .optionallyWith(
        allocationMaxNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): java.lang.Integer
        )
      )(_.allocationMaxNetmaskLength)
      .optionallyWith(
        allocationDefaultNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): java.lang.Integer
        )
      )(_.allocationDefaultNetmaskLength)
      .optionallyWith(
        allocationResourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.allocationResourceTags)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(awsService.map(value => value.unwrap))(_.awsService)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamPool.ReadOnly =
    zio.aws.ec2.model.IpamPool.wrap(buildAwsValue())
}
object IpamPool {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.IpamPool] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamPool = zio.aws.ec2.model.IpamPool(
      ownerId.map(value => value),
      ipamPoolId.map(value => value),
      sourceIpamPoolId.map(value => value),
      ipamPoolArn.map(value => value),
      ipamScopeArn.map(value => value),
      ipamScopeType.map(value => value),
      ipamArn.map(value => value),
      ipamRegion.map(value => value),
      locale.map(value => value),
      poolDepth.map(value => value),
      state.map(value => value),
      stateMessage.map(value => value),
      description.map(value => value),
      autoImport.map(value => value),
      publiclyAdvertisable.map(value => value),
      addressFamily.map(value => value),
      allocationMinNetmaskLength.map(value => value),
      allocationMaxNetmaskLength.map(value => value),
      allocationDefaultNetmaskLength.map(value => value),
      allocationResourceTags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      awsService.map(value => value)
    )
    def ownerId: Option[String]
    def ipamPoolId: Option[IpamPoolId]
    def sourceIpamPoolId: Option[IpamPoolId]
    def ipamPoolArn: Option[ResourceArn]
    def ipamScopeArn: Option[ResourceArn]
    def ipamScopeType: Option[zio.aws.ec2.model.IpamScopeType]
    def ipamArn: Option[ResourceArn]
    def ipamRegion: Option[String]
    def locale: Option[String]
    def poolDepth: Option[Integer]
    def state: Option[zio.aws.ec2.model.IpamPoolState]
    def stateMessage: Option[String]
    def description: Option[String]
    def autoImport: Option[Boolean]
    def publiclyAdvertisable: Option[Boolean]
    def addressFamily: Option[zio.aws.ec2.model.AddressFamily]
    def allocationMinNetmaskLength: Option[IpamNetmaskLength]
    def allocationMaxNetmaskLength: Option[IpamNetmaskLength]
    def allocationDefaultNetmaskLength: Option[IpamNetmaskLength]
    def allocationResourceTags
        : Option[List[zio.aws.ec2.model.IpamResourceTag.ReadOnly]]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def awsService: Option[zio.aws.ec2.model.IpamPoolAwsService]
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getIpamPoolId: ZIO[Any, AwsError, IpamPoolId] =
      AwsError.unwrapOptionField("ipamPoolId", ipamPoolId)
    def getSourceIpamPoolId: ZIO[Any, AwsError, IpamPoolId] =
      AwsError.unwrapOptionField("sourceIpamPoolId", sourceIpamPoolId)
    def getIpamPoolArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ipamPoolArn", ipamPoolArn)
    def getIpamScopeArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ipamScopeArn", ipamScopeArn)
    def getIpamScopeType: ZIO[Any, AwsError, zio.aws.ec2.model.IpamScopeType] =
      AwsError.unwrapOptionField("ipamScopeType", ipamScopeType)
    def getIpamArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ipamArn", ipamArn)
    def getIpamRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipamRegion", ipamRegion)
    def getLocale: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("locale", locale)
    def getPoolDepth: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("poolDepth", poolDepth)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.IpamPoolState] =
      AwsError.unwrapOptionField("state", state)
    def getStateMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateMessage", stateMessage)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getAutoImport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoImport", autoImport)
    def getPubliclyAdvertisable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAdvertisable", publiclyAdvertisable)
    def getAddressFamily: ZIO[Any, AwsError, zio.aws.ec2.model.AddressFamily] =
      AwsError.unwrapOptionField("addressFamily", addressFamily)
    def getAllocationMinNetmaskLength: ZIO[Any, AwsError, IpamNetmaskLength] =
      AwsError.unwrapOptionField(
        "allocationMinNetmaskLength",
        allocationMinNetmaskLength
      )
    def getAllocationMaxNetmaskLength: ZIO[Any, AwsError, IpamNetmaskLength] =
      AwsError.unwrapOptionField(
        "allocationMaxNetmaskLength",
        allocationMaxNetmaskLength
      )
    def getAllocationDefaultNetmaskLength
        : ZIO[Any, AwsError, IpamNetmaskLength] = AwsError.unwrapOptionField(
      "allocationDefaultNetmaskLength",
      allocationDefaultNetmaskLength
    )
    def getAllocationResourceTags
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpamResourceTag.ReadOnly]] =
      AwsError.unwrapOptionField(
        "allocationResourceTags",
        allocationResourceTags
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAwsService
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamPoolAwsService] =
      AwsError.unwrapOptionField("awsService", awsService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamPool
  ) extends zio.aws.ec2.model.IpamPool.ReadOnly {
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val ipamPoolId: Option[IpamPoolId] = scala
      .Option(impl.ipamPoolId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolId(value))
    override val sourceIpamPoolId: Option[IpamPoolId] = scala
      .Option(impl.sourceIpamPoolId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolId(value))
    override val ipamPoolArn: Option[ResourceArn] = scala
      .Option(impl.ipamPoolArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val ipamScopeArn: Option[ResourceArn] = scala
      .Option(impl.ipamScopeArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val ipamScopeType: Option[zio.aws.ec2.model.IpamScopeType] = scala
      .Option(impl.ipamScopeType())
      .map(value => zio.aws.ec2.model.IpamScopeType.wrap(value))
    override val ipamArn: Option[ResourceArn] = scala
      .Option(impl.ipamArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val ipamRegion: Option[String] =
      scala.Option(impl.ipamRegion()).map(value => value: String)
    override val locale: Option[String] =
      scala.Option(impl.locale()).map(value => value: String)
    override val poolDepth: Option[Integer] =
      scala.Option(impl.poolDepth()).map(value => value: Integer)
    override val state: Option[zio.aws.ec2.model.IpamPoolState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.IpamPoolState.wrap(value))
    override val stateMessage: Option[String] =
      scala.Option(impl.stateMessage()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val autoImport: Option[Boolean] =
      scala.Option(impl.autoImport()).map(value => value: Boolean)
    override val publiclyAdvertisable: Option[Boolean] =
      scala.Option(impl.publiclyAdvertisable()).map(value => value: Boolean)
    override val addressFamily: Option[zio.aws.ec2.model.AddressFamily] = scala
      .Option(impl.addressFamily())
      .map(value => zio.aws.ec2.model.AddressFamily.wrap(value))
    override val allocationMinNetmaskLength: Option[IpamNetmaskLength] = scala
      .Option(impl.allocationMinNetmaskLength())
      .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val allocationMaxNetmaskLength: Option[IpamNetmaskLength] = scala
      .Option(impl.allocationMaxNetmaskLength())
      .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val allocationDefaultNetmaskLength: Option[IpamNetmaskLength] =
      scala
        .Option(impl.allocationDefaultNetmaskLength())
        .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val allocationResourceTags
        : Option[List[zio.aws.ec2.model.IpamResourceTag.ReadOnly]] = scala
      .Option(impl.allocationResourceTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IpamResourceTag.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val awsService: Option[zio.aws.ec2.model.IpamPoolAwsService] =
      scala
        .Option(impl.awsService())
        .map(value => zio.aws.ec2.model.IpamPoolAwsService.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamPool
  ): zio.aws.ec2.model.IpamPool.ReadOnly = new Wrapper(impl)
}
