package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IpRange(
    cidrIp: Option[String] = None,
    description: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.IpRange = {
    import IpRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpRange
      .builder()
      .optionallyWith(cidrIp.map(value => value: java.lang.String))(_.cidrIp)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpRange.ReadOnly =
    zio.aws.ec2.model.IpRange.wrap(buildAwsValue())
}
object IpRange {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.IpRange] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpRange = zio.aws.ec2.model
      .IpRange(cidrIp.map(value => value), description.map(value => value))
    def cidrIp: Option[String]
    def description: Option[String]
    def getCidrIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrIp", cidrIp)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpRange
  ) extends zio.aws.ec2.model.IpRange.ReadOnly {
    override val cidrIp: Option[String] =
      scala.Option(impl.cidrIp()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpRange
  ): zio.aws.ec2.model.IpRange.ReadOnly = new Wrapper(impl)
}
