package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceMatchCriteria {
  def unwrap: software.amazon.awssdk.services.ec2.model.InstanceMatchCriteria
}
object InstanceMatchCriteria {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceMatchCriteria
  ): zio.aws.ec2.model.InstanceMatchCriteria = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceMatchCriteria.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceMatchCriteria.OPEN =>
      val r = open
      r
    case software.amazon.awssdk.services.ec2.model.InstanceMatchCriteria.TARGETED =>
      val r = targeted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.InstanceMatchCriteria {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceMatchCriteria =
      software.amazon.awssdk.services.ec2.model.InstanceMatchCriteria.UNKNOWN_TO_SDK_VERSION
  }
  case object open extends zio.aws.ec2.model.InstanceMatchCriteria {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceMatchCriteria =
      software.amazon.awssdk.services.ec2.model.InstanceMatchCriteria.OPEN
  }
  case object targeted extends zio.aws.ec2.model.InstanceMatchCriteria {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceMatchCriteria =
      software.amazon.awssdk.services.ec2.model.InstanceMatchCriteria.TARGETED
  }
}
