package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait FleetCapacityReservationUsageStrategy {
  def unwrap: software.amazon.awssdk.services.ec2.model.FleetCapacityReservationUsageStrategy
}
object FleetCapacityReservationUsageStrategy {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.FleetCapacityReservationUsageStrategy
  ): zio.aws.ec2.model.FleetCapacityReservationUsageStrategy = value match {
    case software.amazon.awssdk.services.ec2.model.FleetCapacityReservationUsageStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.FleetCapacityReservationUsageStrategy.USE_CAPACITY_RESERVATIONS_FIRST =>
      val r = `use-capacity-reservations-first`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.FleetCapacityReservationUsageStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetCapacityReservationUsageStrategy =
      software.amazon.awssdk.services.ec2.model.FleetCapacityReservationUsageStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object `use-capacity-reservations-first`
      extends zio.aws.ec2.model.FleetCapacityReservationUsageStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetCapacityReservationUsageStrategy =
      software.amazon.awssdk.services.ec2.model.FleetCapacityReservationUsageStrategy.USE_CAPACITY_RESERVATIONS_FIRST
  }
}
