package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EventInformation(
    eventDescription: Option[String] = None,
    eventSubType: Option[String] = None,
    instanceId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EventInformation = {
    import EventInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EventInformation
      .builder()
      .optionallyWith(eventDescription.map(value => value: java.lang.String))(
        _.eventDescription
      )
      .optionallyWith(eventSubType.map(value => value: java.lang.String))(
        _.eventSubType
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EventInformation.ReadOnly =
    zio.aws.ec2.model.EventInformation.wrap(buildAwsValue())
}
object EventInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EventInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EventInformation =
      zio.aws.ec2.model.EventInformation(
        eventDescription.map(value => value),
        eventSubType.map(value => value),
        instanceId.map(value => value)
      )
    def eventDescription: Option[String]
    def eventSubType: Option[String]
    def instanceId: Option[String]
    def getEventDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventDescription", eventDescription)
    def getEventSubType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventSubType", eventSubType)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EventInformation
  ) extends zio.aws.ec2.model.EventInformation.ReadOnly {
    override val eventDescription: Option[String] =
      scala.Option(impl.eventDescription()).map(value => value: String)
    override val eventSubType: Option[String] =
      scala.Option(impl.eventSubType()).map(value => value: String)
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EventInformation
  ): zio.aws.ec2.model.EventInformation.ReadOnly = new Wrapper(impl)
}
