package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTagsResponse(
    nextToken: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.TagDescription]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTagsResponse = {
    import DescribeTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTagsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeTagsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeTagsResponse.wrap(buildAwsValue())
}
object DescribeTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeTagsResponse =
      zio.aws.ec2.model.DescribeTagsResponse(
        nextToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def tags: Option[List[zio.aws.ec2.model.TagDescription.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.TagDescription.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTagsResponse
  ) extends zio.aws.ec2.model.DescribeTagsResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.TagDescription.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagDescription.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTagsResponse
  ): zio.aws.ec2.model.DescribeTagsResponse.ReadOnly = new Wrapper(impl)
}
