package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SpotFleetRequestId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSpotFleetRequestsRequest(
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None,
    spotFleetRequestIds: Option[Iterable[SpotFleetRequestId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest = {
    import DescribeSpotFleetRequestsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        spotFleetRequestIds.map(value =>
          value.map { item =>
            SpotFleetRequestId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.spotFleetRequestIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSpotFleetRequestsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSpotFleetRequestsRequest.wrap(buildAwsValue())
}
object DescribeSpotFleetRequestsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSpotFleetRequestsRequest =
      zio.aws.ec2.model.DescribeSpotFleetRequestsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        spotFleetRequestIds.map(value => value)
      )
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def spotFleetRequestIds: Option[List[SpotFleetRequestId]]
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSpotFleetRequestIds: ZIO[Any, AwsError, List[SpotFleetRequestId]] =
      AwsError.unwrapOptionField("spotFleetRequestIds", spotFleetRequestIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest
  ) extends zio.aws.ec2.model.DescribeSpotFleetRequestsRequest.ReadOnly {
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val spotFleetRequestIds: Option[List[SpotFleetRequestId]] = scala
      .Option(impl.spotFleetRequestIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SpotFleetRequestId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest
  ): zio.aws.ec2.model.DescribeSpotFleetRequestsRequest.ReadOnly = new Wrapper(
    impl
  )
}
