package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInterfacePermissionsResponse(
    networkInterfacePermissions: Option[
      Iterable[zio.aws.ec2.model.NetworkInterfacePermission]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsResponse = {
    import DescribeNetworkInterfacePermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsResponse
      .builder()
      .optionallyWith(
        networkInterfacePermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfacePermissions)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeNetworkInterfacePermissionsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInterfacePermissionsResponse
      .wrap(buildAwsValue())
}
object DescribeNetworkInterfacePermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeNetworkInterfacePermissionsResponse =
      zio.aws.ec2.model.DescribeNetworkInterfacePermissionsResponse(
        networkInterfacePermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkInterfacePermissions
        : Option[List[zio.aws.ec2.model.NetworkInterfacePermission.ReadOnly]]
    def nextToken: Option[String]
    def getNetworkInterfacePermissions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.NetworkInterfacePermission.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "networkInterfacePermissions",
      networkInterfacePermissions
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsResponse
  ) extends zio.aws.ec2.model.DescribeNetworkInterfacePermissionsResponse.ReadOnly {
    override val networkInterfacePermissions
        : Option[List[zio.aws.ec2.model.NetworkInterfacePermission.ReadOnly]] =
      scala
        .Option(impl.networkInterfacePermissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.NetworkInterfacePermission.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsResponse
  ): zio.aws.ec2.model.DescribeNetworkInterfacePermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
