package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInsightsPathsResponse(
    networkInsightsPaths: Option[
      Iterable[zio.aws.ec2.model.NetworkInsightsPath]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsResponse = {
    import DescribeNetworkInsightsPathsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsResponse
      .builder()
      .optionallyWith(
        networkInsightsPaths.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInsightsPaths)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeNetworkInsightsPathsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInsightsPathsResponse.wrap(buildAwsValue())
}
object DescribeNetworkInsightsPathsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeNetworkInsightsPathsResponse =
      zio.aws.ec2.model.DescribeNetworkInsightsPathsResponse(
        networkInsightsPaths.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkInsightsPaths
        : Option[List[zio.aws.ec2.model.NetworkInsightsPath.ReadOnly]]
    def nextToken: Option[String]
    def getNetworkInsightsPaths: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.NetworkInsightsPath.ReadOnly
    ]] =
      AwsError.unwrapOptionField("networkInsightsPaths", networkInsightsPaths)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsResponse
  ) extends zio.aws.ec2.model.DescribeNetworkInsightsPathsResponse.ReadOnly {
    override val networkInsightsPaths
        : Option[List[zio.aws.ec2.model.NetworkInsightsPath.ReadOnly]] = scala
      .Option(impl.networkInsightsPaths())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.NetworkInsightsPath.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsResponse
  ): zio.aws.ec2.model.DescribeNetworkInsightsPathsResponse.ReadOnly =
    new Wrapper(impl)
}
