package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeIpv6PoolsResponse(
    ipv6Pools: Option[Iterable[zio.aws.ec2.model.Ipv6Pool]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsResponse = {
    import DescribeIpv6PoolsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsResponse
      .builder()
      .optionallyWith(
        ipv6Pools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Pools)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeIpv6PoolsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeIpv6PoolsResponse.wrap(buildAwsValue())
}
object DescribeIpv6PoolsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeIpv6PoolsResponse =
      zio.aws.ec2.model.DescribeIpv6PoolsResponse(
        ipv6Pools.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def ipv6Pools: Option[List[zio.aws.ec2.model.Ipv6Pool.ReadOnly]]
    def nextToken: Option[NextToken]
    def getIpv6Pools
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Ipv6Pool.ReadOnly]] =
      AwsError.unwrapOptionField("ipv6Pools", ipv6Pools)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsResponse
  ) extends zio.aws.ec2.model.DescribeIpv6PoolsResponse.ReadOnly {
    override val ipv6Pools: Option[List[zio.aws.ec2.model.Ipv6Pool.ReadOnly]] =
      scala
        .Option(impl.ipv6Pools())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Ipv6Pool.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsResponse
  ): zio.aws.ec2.model.DescribeIpv6PoolsResponse.ReadOnly = new Wrapper(impl)
}
