package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeFpgaImagesResponse(
    fpgaImages: Option[Iterable[zio.aws.ec2.model.FpgaImage]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesResponse = {
    import DescribeFpgaImagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesResponse
      .builder()
      .optionallyWith(
        fpgaImages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fpgaImages)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFpgaImagesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeFpgaImagesResponse.wrap(buildAwsValue())
}
object DescribeFpgaImagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFpgaImagesResponse =
      zio.aws.ec2.model.DescribeFpgaImagesResponse(
        fpgaImages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fpgaImages: Option[List[zio.aws.ec2.model.FpgaImage.ReadOnly]]
    def nextToken: Option[NextToken]
    def getFpgaImages
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.FpgaImage.ReadOnly]] =
      AwsError.unwrapOptionField("fpgaImages", fpgaImages)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesResponse
  ) extends zio.aws.ec2.model.DescribeFpgaImagesResponse.ReadOnly {
    override val fpgaImages
        : Option[List[zio.aws.ec2.model.FpgaImage.ReadOnly]] = scala
      .Option(impl.fpgaImages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.FpgaImage.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesResponse
  ): zio.aws.ec2.model.DescribeFpgaImagesResponse.ReadOnly = new Wrapper(impl)
}
