package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.CustomerGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeCustomerGatewaysRequest(
    customerGatewayIds: Option[Iterable[CustomerGatewayId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest = {
    import DescribeCustomerGatewaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest
      .builder()
      .optionallyWith(
        customerGatewayIds.map(value =>
          value.map { item =>
            CustomerGatewayId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.customerGatewayIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeCustomerGatewaysRequest.ReadOnly =
    zio.aws.ec2.model.DescribeCustomerGatewaysRequest.wrap(buildAwsValue())
}
object DescribeCustomerGatewaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeCustomerGatewaysRequest =
      zio.aws.ec2.model.DescribeCustomerGatewaysRequest(
        customerGatewayIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def customerGatewayIds: Option[List[CustomerGatewayId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getCustomerGatewayIds: ZIO[Any, AwsError, List[CustomerGatewayId]] =
      AwsError.unwrapOptionField("customerGatewayIds", customerGatewayIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest
  ) extends zio.aws.ec2.model.DescribeCustomerGatewaysRequest.ReadOnly {
    override val customerGatewayIds: Option[List[CustomerGatewayId]] = scala
      .Option(impl.customerGatewayIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.CustomerGatewayId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest
  ): zio.aws.ec2.model.DescribeCustomerGatewaysRequest.ReadOnly = new Wrapper(
    impl
  )
}
