package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAddressesResponse(
    addresses: Option[Iterable[zio.aws.ec2.model.Address]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAddressesResponse = {
    import DescribeAddressesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAddressesResponse
      .builder()
      .optionallyWith(
        addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addresses)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeAddressesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeAddressesResponse.wrap(buildAwsValue())
}
object DescribeAddressesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAddressesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeAddressesResponse =
      zio.aws.ec2.model.DescribeAddressesResponse(
        addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def addresses: Option[List[zio.aws.ec2.model.Address.ReadOnly]]
    def getAddresses
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Address.ReadOnly]] =
      AwsError.unwrapOptionField("addresses", addresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAddressesResponse
  ) extends zio.aws.ec2.model.DescribeAddressesResponse.ReadOnly {
    override val addresses: Option[List[zio.aws.ec2.model.Address.ReadOnly]] =
      scala
        .Option(impl.addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Address.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAddressesResponse
  ): zio.aws.ec2.model.DescribeAddressesResponse.ReadOnly = new Wrapper(impl)
}
