package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteTrafficMirrorFilterRuleResponse(
    trafficMirrorFilterRuleId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleResponse = {
    import DeleteTrafficMirrorFilterRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleResponse
      .builder()
      .optionallyWith(
        trafficMirrorFilterRuleId.map(value => value: java.lang.String)
      )(_.trafficMirrorFilterRuleId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleResponse.ReadOnly =
    zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleResponse
      .wrap(buildAwsValue())
}
object DeleteTrafficMirrorFilterRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleResponse =
      zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleResponse(
        trafficMirrorFilterRuleId.map(value => value)
      )
    def trafficMirrorFilterRuleId: Option[String]
    def getTrafficMirrorFilterRuleId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("trafficMirrorFilterRuleId", trafficMirrorFilterRuleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleResponse
  ) extends zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleResponse.ReadOnly {
    override val trafficMirrorFilterRuleId: Option[String] =
      scala.Option(impl.trafficMirrorFilterRuleId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleResponse
  ): zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleResponse.ReadOnly =
    new Wrapper(impl)
}
