package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SnapshotId, KmsKeyId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVolumeRequest(
    availabilityZone: String,
    encrypted: Option[Boolean] = None,
    iops: Option[Integer] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    outpostArn: Option[String] = None,
    size: Option[Integer] = None,
    snapshotId: Option[SnapshotId] = None,
    volumeType: Option[zio.aws.ec2.model.VolumeType] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    multiAttachEnabled: Option[Boolean] = None,
    throughput: Option[Integer] = None,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVolumeRequest = {
    import CreateVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVolumeRequest
      .builder()
      .availabilityZone(availabilityZone: java.lang.String)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(size.map(value => value: java.lang.Integer))(_.size)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(volumeType.map(value => value.unwrap))(_.volumeType)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(
        multiAttachEnabled.map(value => value: java.lang.Boolean)
      )(_.multiAttachEnabled)
      .optionallyWith(throughput.map(value => value: java.lang.Integer))(
        _.throughput
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVolumeRequest.ReadOnly =
    zio.aws.ec2.model.CreateVolumeRequest.wrap(buildAwsValue())
}
object CreateVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVolumeRequest =
      zio.aws.ec2.model.CreateVolumeRequest(
        availabilityZone,
        encrypted.map(value => value),
        iops.map(value => value),
        kmsKeyId.map(value => value),
        outpostArn.map(value => value),
        size.map(value => value),
        snapshotId.map(value => value),
        volumeType.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        multiAttachEnabled.map(value => value),
        throughput.map(value => value),
        clientToken.map(value => value)
      )
    def availabilityZone: String
    def encrypted: Option[Boolean]
    def iops: Option[Integer]
    def kmsKeyId: Option[KmsKeyId]
    def outpostArn: Option[String]
    def size: Option[Integer]
    def snapshotId: Option[SnapshotId]
    def volumeType: Option[zio.aws.ec2.model.VolumeType]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def multiAttachEnabled: Option[Boolean]
    def throughput: Option[Integer]
    def clientToken: Option[String]
    def getAvailabilityZone: ZIO[Any, Nothing, String] =
      ZIO.succeed(availabilityZone)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("size", size)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getVolumeType: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getMultiAttachEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAttachEnabled", multiAttachEnabled)
    def getThroughput: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("throughput", throughput)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVolumeRequest
  ) extends zio.aws.ec2.model.CreateVolumeRequest.ReadOnly {
    override val availabilityZone: String = impl.availabilityZone(): String
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val iops: Option[Integer] =
      scala.Option(impl.iops()).map(value => value: Integer)
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.ec2.model.primitives.KmsKeyId(value))
    override val outpostArn: Option[String] =
      scala.Option(impl.outpostArn()).map(value => value: String)
    override val size: Option[Integer] =
      scala.Option(impl.size()).map(value => value: Integer)
    override val snapshotId: Option[SnapshotId] = scala
      .Option(impl.snapshotId())
      .map(value => zio.aws.ec2.model.primitives.SnapshotId(value))
    override val volumeType: Option[zio.aws.ec2.model.VolumeType] = scala
      .Option(impl.volumeType())
      .map(value => zio.aws.ec2.model.VolumeType.wrap(value))
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val multiAttachEnabled: Option[Boolean] =
      scala.Option(impl.multiAttachEnabled()).map(value => value: Boolean)
    override val throughput: Option[Integer] =
      scala.Option(impl.throughput()).map(value => value: Integer)
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVolumeRequest
  ): zio.aws.ec2.model.CreateVolumeRequest.ReadOnly = new Wrapper(impl)
}
