package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateTrafficMirrorSessionResponse(
    trafficMirrorSession: Option[zio.aws.ec2.model.TrafficMirrorSession] = None,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionResponse = {
    import CreateTrafficMirrorSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionResponse
      .builder()
      .optionallyWith(trafficMirrorSession.map(value => value.buildAwsValue()))(
        _.trafficMirrorSession
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTrafficMirrorSessionResponse.ReadOnly =
    zio.aws.ec2.model.CreateTrafficMirrorSessionResponse.wrap(buildAwsValue())
}
object CreateTrafficMirrorSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTrafficMirrorSessionResponse =
      zio.aws.ec2.model.CreateTrafficMirrorSessionResponse(
        trafficMirrorSession.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def trafficMirrorSession
        : Option[zio.aws.ec2.model.TrafficMirrorSession.ReadOnly]
    def clientToken: Option[String]
    def getTrafficMirrorSession
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrafficMirrorSession.ReadOnly] =
      AwsError.unwrapOptionField("trafficMirrorSession", trafficMirrorSession)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionResponse
  ) extends zio.aws.ec2.model.CreateTrafficMirrorSessionResponse.ReadOnly {
    override val trafficMirrorSession
        : Option[zio.aws.ec2.model.TrafficMirrorSession.ReadOnly] = scala
      .Option(impl.trafficMirrorSession())
      .map(value => zio.aws.ec2.model.TrafficMirrorSession.wrap(value))
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionResponse
  ): zio.aws.ec2.model.CreateTrafficMirrorSessionResponse.ReadOnly =
    new Wrapper(impl)
}
