package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Ipv4PoolEc2Id
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreatePublicIpv4PoolResponse(
    poolId: Option[Ipv4PoolEc2Id] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolResponse = {
    import CreatePublicIpv4PoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolResponse
      .builder()
      .optionallyWith(
        poolId.map(value => Ipv4PoolEc2Id.unwrap(value): java.lang.String)
      )(_.poolId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreatePublicIpv4PoolResponse.ReadOnly =
    zio.aws.ec2.model.CreatePublicIpv4PoolResponse.wrap(buildAwsValue())
}
object CreatePublicIpv4PoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreatePublicIpv4PoolResponse =
      zio.aws.ec2.model.CreatePublicIpv4PoolResponse(poolId.map(value => value))
    def poolId: Option[Ipv4PoolEc2Id]
    def getPoolId: ZIO[Any, AwsError, Ipv4PoolEc2Id] =
      AwsError.unwrapOptionField("poolId", poolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolResponse
  ) extends zio.aws.ec2.model.CreatePublicIpv4PoolResponse.ReadOnly {
    override val poolId: Option[Ipv4PoolEc2Id] = scala
      .Option(impl.poolId())
      .map(value => zio.aws.ec2.model.primitives.Ipv4PoolEc2Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolResponse
  ): zio.aws.ec2.model.CreatePublicIpv4PoolResponse.ReadOnly = new Wrapper(impl)
}
