package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreatePublicIpv4PoolRequest(
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolRequest = {
    import CreatePublicIpv4PoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolRequest
      .builder()
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreatePublicIpv4PoolRequest.ReadOnly =
    zio.aws.ec2.model.CreatePublicIpv4PoolRequest.wrap(buildAwsValue())
}
object CreatePublicIpv4PoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreatePublicIpv4PoolRequest =
      zio.aws.ec2.model.CreatePublicIpv4PoolRequest(
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolRequest
  ) extends zio.aws.ec2.model.CreatePublicIpv4PoolRequest.ReadOnly {
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolRequest
  ): zio.aws.ec2.model.CreatePublicIpv4PoolRequest.ReadOnly = new Wrapper(impl)
}
