package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SubnetId, Integer, SecurityGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateNetworkInterfaceRequest(
    description: Option[String] = None,
    groups: Option[Iterable[SecurityGroupId]] = None,
    ipv6AddressCount: Option[Integer] = None,
    ipv6Addresses: Option[Iterable[zio.aws.ec2.model.InstanceIpv6Address]] =
      None,
    privateIpAddress: Option[String] = None,
    privateIpAddresses: Option[
      Iterable[zio.aws.ec2.model.PrivateIpAddressSpecification]
    ] = None,
    secondaryPrivateIpAddressCount: Option[Integer] = None,
    ipv4Prefixes: Option[
      Iterable[zio.aws.ec2.model.Ipv4PrefixSpecificationRequest]
    ] = None,
    ipv4PrefixCount: Option[Integer] = None,
    ipv6Prefixes: Option[
      Iterable[zio.aws.ec2.model.Ipv6PrefixSpecificationRequest]
    ] = None,
    ipv6PrefixCount: Option[Integer] = None,
    interfaceType: Option[zio.aws.ec2.model.NetworkInterfaceCreationType] =
      None,
    subnetId: SubnetId,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest = {
    import CreateNetworkInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(ipv6AddressCount.map(value => value: java.lang.Integer))(
        _.ipv6AddressCount
      )
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(
        secondaryPrivateIpAddressCount.map(value => value: java.lang.Integer)
      )(_.secondaryPrivateIpAddressCount)
      .optionallyWith(
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv4Prefixes)
      .optionallyWith(ipv4PrefixCount.map(value => value: java.lang.Integer))(
        _.ipv4PrefixCount
      )
      .optionallyWith(
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Prefixes)
      .optionallyWith(ipv6PrefixCount.map(value => value: java.lang.Integer))(
        _.ipv6PrefixCount
      )
      .optionallyWith(interfaceType.map(value => value.unwrap))(_.interfaceType)
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateNetworkInterfaceRequest.ReadOnly =
    zio.aws.ec2.model.CreateNetworkInterfaceRequest.wrap(buildAwsValue())
}
object CreateNetworkInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNetworkInterfaceRequest =
      zio.aws.ec2.model.CreateNetworkInterfaceRequest(
        description.map(value => value),
        groups.map(value => value),
        ipv6AddressCount.map(value => value),
        ipv6Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privateIpAddress.map(value => value),
        privateIpAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secondaryPrivateIpAddressCount.map(value => value),
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv4PrefixCount.map(value => value),
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv6PrefixCount.map(value => value),
        interfaceType.map(value => value),
        subnetId,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def description: Option[String]
    def groups: Option[List[SecurityGroupId]]
    def ipv6AddressCount: Option[Integer]
    def ipv6Addresses
        : Option[List[zio.aws.ec2.model.InstanceIpv6Address.ReadOnly]]
    def privateIpAddress: Option[String]
    def privateIpAddresses
        : Option[List[zio.aws.ec2.model.PrivateIpAddressSpecification.ReadOnly]]
    def secondaryPrivateIpAddressCount: Option[Integer]
    def ipv4Prefixes: Option[
      List[zio.aws.ec2.model.Ipv4PrefixSpecificationRequest.ReadOnly]
    ]
    def ipv4PrefixCount: Option[Integer]
    def ipv6Prefixes: Option[
      List[zio.aws.ec2.model.Ipv6PrefixSpecificationRequest.ReadOnly]
    ]
    def ipv6PrefixCount: Option[Integer]
    def interfaceType: Option[zio.aws.ec2.model.NetworkInterfaceCreationType]
    def subnetId: SubnetId
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def clientToken: Option[String]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("groups", groups)
    def getIpv6AddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv6AddressCount", ipv6AddressCount)
    def getIpv6Addresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceIpv6Address.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPrivateIpAddresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.PrivateIpAddressSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getSecondaryPrivateIpAddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "secondaryPrivateIpAddressCount",
        secondaryPrivateIpAddressCount
      )
    def getIpv4Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Ipv4PrefixSpecificationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv4Prefixes", ipv4Prefixes)
    def getIpv4PrefixCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv4PrefixCount", ipv4PrefixCount)
    def getIpv6Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Ipv6PrefixSpecificationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Prefixes", ipv6Prefixes)
    def getIpv6PrefixCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv6PrefixCount", ipv6PrefixCount)
    def getInterfaceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkInterfaceCreationType] =
      AwsError.unwrapOptionField("interfaceType", interfaceType)
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest
  ) extends zio.aws.ec2.model.CreateNetworkInterfaceRequest.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val groups: Option[List[SecurityGroupId]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val ipv6AddressCount: Option[Integer] =
      scala.Option(impl.ipv6AddressCount()).map(value => value: Integer)
    override val ipv6Addresses
        : Option[List[zio.aws.ec2.model.InstanceIpv6Address.ReadOnly]] = scala
      .Option(impl.ipv6Addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceIpv6Address.wrap(item)
        }.toList
      )
    override val privateIpAddress: Option[String] =
      scala.Option(impl.privateIpAddress()).map(value => value: String)
    override val privateIpAddresses: Option[
      List[zio.aws.ec2.model.PrivateIpAddressSpecification.ReadOnly]
    ] = scala
      .Option(impl.privateIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PrivateIpAddressSpecification.wrap(item)
        }.toList
      )
    override val secondaryPrivateIpAddressCount: Option[Integer] = scala
      .Option(impl.secondaryPrivateIpAddressCount())
      .map(value => value: Integer)
    override val ipv4Prefixes: Option[
      List[zio.aws.ec2.model.Ipv4PrefixSpecificationRequest.ReadOnly]
    ] = scala
      .Option(impl.ipv4Prefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Ipv4PrefixSpecificationRequest.wrap(item)
        }.toList
      )
    override val ipv4PrefixCount: Option[Integer] =
      scala.Option(impl.ipv4PrefixCount()).map(value => value: Integer)
    override val ipv6Prefixes: Option[
      List[zio.aws.ec2.model.Ipv6PrefixSpecificationRequest.ReadOnly]
    ] = scala
      .Option(impl.ipv6Prefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Ipv6PrefixSpecificationRequest.wrap(item)
        }.toList
      )
    override val ipv6PrefixCount: Option[Integer] =
      scala.Option(impl.ipv6PrefixCount()).map(value => value: Integer)
    override val interfaceType
        : Option[zio.aws.ec2.model.NetworkInterfaceCreationType] = scala
      .Option(impl.interfaceType())
      .map(value => zio.aws.ec2.model.NetworkInterfaceCreationType.wrap(value))
    override val subnetId: SubnetId =
      zio.aws.ec2.model.primitives.SubnetId(impl.subnetId())
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest
  ): zio.aws.ec2.model.CreateNetworkInterfaceRequest.ReadOnly = new Wrapper(
    impl
  )
}
