package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.KmsKeyId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CopyImageRequest(
    clientToken: Option[String] = None,
    description: Option[String] = None,
    encrypted: Option[Boolean] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    name: String,
    sourceImageId: String,
    sourceRegion: String,
    destinationOutpostArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CopyImageRequest = {
    import CopyImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CopyImageRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .name(name: java.lang.String)
      .sourceImageId(sourceImageId: java.lang.String)
      .sourceRegion(sourceRegion: java.lang.String)
      .optionallyWith(
        destinationOutpostArn.map(value => value: java.lang.String)
      )(_.destinationOutpostArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CopyImageRequest.ReadOnly =
    zio.aws.ec2.model.CopyImageRequest.wrap(buildAwsValue())
}
object CopyImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CopyImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CopyImageRequest =
      zio.aws.ec2.model.CopyImageRequest(
        clientToken.map(value => value),
        description.map(value => value),
        encrypted.map(value => value),
        kmsKeyId.map(value => value),
        name,
        sourceImageId,
        sourceRegion,
        destinationOutpostArn.map(value => value)
      )
    def clientToken: Option[String]
    def description: Option[String]
    def encrypted: Option[Boolean]
    def kmsKeyId: Option[KmsKeyId]
    def name: String
    def sourceImageId: String
    def sourceRegion: String
    def destinationOutpostArn: Option[String]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getSourceImageId: ZIO[Any, Nothing, String] = ZIO.succeed(sourceImageId)
    def getSourceRegion: ZIO[Any, Nothing, String] = ZIO.succeed(sourceRegion)
    def getDestinationOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationOutpostArn", destinationOutpostArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CopyImageRequest
  ) extends zio.aws.ec2.model.CopyImageRequest.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.ec2.model.primitives.KmsKeyId(value))
    override val name: String = impl.name(): String
    override val sourceImageId: String = impl.sourceImageId(): String
    override val sourceRegion: String = impl.sourceRegion(): String
    override val destinationOutpostArn: Option[String] =
      scala.Option(impl.destinationOutpostArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CopyImageRequest
  ): zio.aws.ec2.model.CopyImageRequest.ReadOnly = new Wrapper(impl)
}
