package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  ResourceArn,
  LocalGatewayRoutetableId,
  CoipPoolId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CoipPool(
    poolId: Option[CoipPoolId] = None,
    poolCidrs: Option[Iterable[String]] = None,
    localGatewayRouteTableId: Option[LocalGatewayRoutetableId] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    poolArn: Option[ResourceArn] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.CoipPool = {
    import CoipPool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CoipPool
      .builder()
      .optionallyWith(
        poolId.map(value => CoipPoolId.unwrap(value): java.lang.String)
      )(_.poolId)
      .optionallyWith(
        poolCidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.poolCidrs)
      .optionallyWith(
        localGatewayRouteTableId.map(value =>
          LocalGatewayRoutetableId.unwrap(value): java.lang.String
        )
      )(_.localGatewayRouteTableId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        poolArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.poolArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CoipPool.ReadOnly =
    zio.aws.ec2.model.CoipPool.wrap(buildAwsValue())
}
object CoipPool {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.CoipPool] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CoipPool = zio.aws.ec2.model.CoipPool(
      poolId.map(value => value),
      poolCidrs.map(value => value),
      localGatewayRouteTableId.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      poolArn.map(value => value)
    )
    def poolId: Option[CoipPoolId]
    def poolCidrs: Option[List[String]]
    def localGatewayRouteTableId: Option[LocalGatewayRoutetableId]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def poolArn: Option[ResourceArn]
    def getPoolId: ZIO[Any, AwsError, CoipPoolId] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getPoolCidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("poolCidrs", poolCidrs)
    def getLocalGatewayRouteTableId
        : ZIO[Any, AwsError, LocalGatewayRoutetableId] = AwsError
      .unwrapOptionField("localGatewayRouteTableId", localGatewayRouteTableId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPoolArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("poolArn", poolArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CoipPool
  ) extends zio.aws.ec2.model.CoipPool.ReadOnly {
    override val poolId: Option[CoipPoolId] = scala
      .Option(impl.poolId())
      .map(value => zio.aws.ec2.model.primitives.CoipPoolId(value))
    override val poolCidrs: Option[List[String]] = scala
      .Option(impl.poolCidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val localGatewayRouteTableId: Option[LocalGatewayRoutetableId] =
      scala
        .Option(impl.localGatewayRouteTableId())
        .map(value =>
          zio.aws.ec2.model.primitives.LocalGatewayRoutetableId(value)
        )
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val poolArn: Option[ResourceArn] = scala
      .Option(impl.poolArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CoipPool
  ): zio.aws.ec2.model.CoipPool.ReadOnly = new Wrapper(impl)
}
