package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClassicLoadBalancersConfig(
    classicLoadBalancers: Option[
      Iterable[zio.aws.ec2.model.ClassicLoadBalancer]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClassicLoadBalancersConfig = {
    import ClassicLoadBalancersConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClassicLoadBalancersConfig
      .builder()
      .optionallyWith(
        classicLoadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.classicLoadBalancers)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClassicLoadBalancersConfig.ReadOnly =
    zio.aws.ec2.model.ClassicLoadBalancersConfig.wrap(buildAwsValue())
}
object ClassicLoadBalancersConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClassicLoadBalancersConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClassicLoadBalancersConfig =
      zio.aws.ec2.model.ClassicLoadBalancersConfig(
        classicLoadBalancers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def classicLoadBalancers
        : Option[List[zio.aws.ec2.model.ClassicLoadBalancer.ReadOnly]]
    def getClassicLoadBalancers: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ClassicLoadBalancer.ReadOnly
    ]] =
      AwsError.unwrapOptionField("classicLoadBalancers", classicLoadBalancers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClassicLoadBalancersConfig
  ) extends zio.aws.ec2.model.ClassicLoadBalancersConfig.ReadOnly {
    override val classicLoadBalancers
        : Option[List[zio.aws.ec2.model.ClassicLoadBalancer.ReadOnly]] = scala
      .Option(impl.classicLoadBalancers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ClassicLoadBalancer.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClassicLoadBalancersConfig
  ): zio.aws.ec2.model.ClassicLoadBalancersConfig.ReadOnly = new Wrapper(impl)
}
