package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Blob
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BlobAttributeValue(value: Option[Blob] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.BlobAttributeValue = {
    import BlobAttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.BlobAttributeValue
      .builder()
      .optionallyWith(
        value.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.BlobAttributeValue.ReadOnly =
    zio.aws.ec2.model.BlobAttributeValue.wrap(buildAwsValue())
}
object BlobAttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.BlobAttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.BlobAttributeValue =
      zio.aws.ec2.model.BlobAttributeValue(value.map(value => value))
    def value: Option[Blob]
    def getValue: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.BlobAttributeValue
  ) extends zio.aws.ec2.model.BlobAttributeValue.ReadOnly {
    override val value: Option[Blob] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.ec2.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.BlobAttributeValue
  ): zio.aws.ec2.model.BlobAttributeValue.ReadOnly = new Wrapper(impl)
}
