package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ClientVpnEndpointId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AuthorizeClientVpnIngressRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    targetNetworkCidr: String,
    accessGroupId: Option[String] = None,
    authorizeAllGroups: Option[Boolean] = None,
    description: Option[String] = None,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressRequest = {
    import AuthorizeClientVpnIngressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .targetNetworkCidr(targetNetworkCidr: java.lang.String)
      .optionallyWith(accessGroupId.map(value => value: java.lang.String))(
        _.accessGroupId
      )
      .optionallyWith(
        authorizeAllGroups.map(value => value: java.lang.Boolean)
      )(_.authorizeAllGroups)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AuthorizeClientVpnIngressRequest.ReadOnly =
    zio.aws.ec2.model.AuthorizeClientVpnIngressRequest.wrap(buildAwsValue())
}
object AuthorizeClientVpnIngressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AuthorizeClientVpnIngressRequest =
      zio.aws.ec2.model.AuthorizeClientVpnIngressRequest(
        clientVpnEndpointId,
        targetNetworkCidr,
        accessGroupId.map(value => value),
        authorizeAllGroups.map(value => value),
        description.map(value => value),
        clientToken.map(value => value)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def targetNetworkCidr: String
    def accessGroupId: Option[String]
    def authorizeAllGroups: Option[Boolean]
    def description: Option[String]
    def clientToken: Option[String]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getTargetNetworkCidr: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetNetworkCidr)
    def getAccessGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accessGroupId", accessGroupId)
    def getAuthorizeAllGroups: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("authorizeAllGroups", authorizeAllGroups)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressRequest
  ) extends zio.aws.ec2.model.AuthorizeClientVpnIngressRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val targetNetworkCidr: String = impl.targetNetworkCidr(): String
    override val accessGroupId: Option[String] =
      scala.Option(impl.accessGroupId()).map(value => value: String)
    override val authorizeAllGroups: Option[Boolean] =
      scala.Option(impl.authorizeAllGroups()).map(value => value: Boolean)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressRequest
  ): zio.aws.ec2.model.AuthorizeClientVpnIngressRequest.ReadOnly = new Wrapper(
    impl
  )
}
