package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssignedPrivateIpAddress(
    privateIpAddress: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssignedPrivateIpAddress = {
    import AssignedPrivateIpAddress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssignedPrivateIpAddress
      .builder()
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssignedPrivateIpAddress.ReadOnly =
    zio.aws.ec2.model.AssignedPrivateIpAddress.wrap(buildAwsValue())
}
object AssignedPrivateIpAddress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssignedPrivateIpAddress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssignedPrivateIpAddress =
      zio.aws.ec2.model
        .AssignedPrivateIpAddress(privateIpAddress.map(value => value))
    def privateIpAddress: Option[String]
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssignedPrivateIpAddress
  ) extends zio.aws.ec2.model.AssignedPrivateIpAddress.ReadOnly {
    override val privateIpAddress: Option[String] =
      scala.Option(impl.privateIpAddress()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssignedPrivateIpAddress
  ): zio.aws.ec2.model.AssignedPrivateIpAddress.ReadOnly = new Wrapper(impl)
}
