package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, NetworkInterfaceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssignPrivateIpAddressesRequest(
    allowReassignment: Option[Boolean] = None,
    networkInterfaceId: NetworkInterfaceId,
    privateIpAddresses: Option[Iterable[String]] = None,
    secondaryPrivateIpAddressCount: Option[Integer] = None,
    ipv4Prefixes: Option[Iterable[String]] = None,
    ipv4PrefixCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesRequest = {
    import AssignPrivateIpAddressesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesRequest
      .builder()
      .optionallyWith(allowReassignment.map(value => value: java.lang.Boolean))(
        _.allowReassignment
      )
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(
        secondaryPrivateIpAddressCount.map(value => value: java.lang.Integer)
      )(_.secondaryPrivateIpAddressCount)
      .optionallyWith(
        ipv4Prefixes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ipv4Prefixes)
      .optionallyWith(ipv4PrefixCount.map(value => value: java.lang.Integer))(
        _.ipv4PrefixCount
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssignPrivateIpAddressesRequest.ReadOnly =
    zio.aws.ec2.model.AssignPrivateIpAddressesRequest.wrap(buildAwsValue())
}
object AssignPrivateIpAddressesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssignPrivateIpAddressesRequest =
      zio.aws.ec2.model.AssignPrivateIpAddressesRequest(
        allowReassignment.map(value => value),
        networkInterfaceId,
        privateIpAddresses.map(value => value),
        secondaryPrivateIpAddressCount.map(value => value),
        ipv4Prefixes.map(value => value),
        ipv4PrefixCount.map(value => value)
      )
    def allowReassignment: Option[Boolean]
    def networkInterfaceId: NetworkInterfaceId
    def privateIpAddresses: Option[List[String]]
    def secondaryPrivateIpAddressCount: Option[Integer]
    def ipv4Prefixes: Option[List[String]]
    def ipv4PrefixCount: Option[Integer]
    def getAllowReassignment: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowReassignment", allowReassignment)
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
    def getPrivateIpAddresses: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getSecondaryPrivateIpAddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "secondaryPrivateIpAddressCount",
        secondaryPrivateIpAddressCount
      )
    def getIpv4Prefixes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ipv4Prefixes", ipv4Prefixes)
    def getIpv4PrefixCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv4PrefixCount", ipv4PrefixCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesRequest
  ) extends zio.aws.ec2.model.AssignPrivateIpAddressesRequest.ReadOnly {
    override val allowReassignment: Option[Boolean] =
      scala.Option(impl.allowReassignment()).map(value => value: Boolean)
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId(impl.networkInterfaceId())
    override val privateIpAddresses: Option[List[String]] = scala
      .Option(impl.privateIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val secondaryPrivateIpAddressCount: Option[Integer] = scala
      .Option(impl.secondaryPrivateIpAddressCount())
      .map(value => value: Integer)
    override val ipv4Prefixes: Option[List[String]] = scala
      .Option(impl.ipv4Prefixes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val ipv4PrefixCount: Option[Integer] =
      scala.Option(impl.ipv4PrefixCount()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesRequest
  ): zio.aws.ec2.model.AssignPrivateIpAddressesRequest.ReadOnly = new Wrapper(
    impl
  )
}
