package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AccountAttribute(
    attributeName: Option[String] = None,
    attributeValues: Option[Iterable[zio.aws.ec2.model.AccountAttributeValue]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AccountAttribute = {
    import AccountAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AccountAttribute
      .builder()
      .optionallyWith(attributeName.map(value => value: java.lang.String))(
        _.attributeName
      )
      .optionallyWith(
        attributeValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributeValues)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AccountAttribute.ReadOnly =
    zio.aws.ec2.model.AccountAttribute.wrap(buildAwsValue())
}
object AccountAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AccountAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AccountAttribute =
      zio.aws.ec2.model.AccountAttribute(
        attributeName.map(value => value),
        attributeValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attributeName: Option[String]
    def attributeValues
        : Option[List[zio.aws.ec2.model.AccountAttributeValue.ReadOnly]]
    def getAttributeName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getAttributeValues: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AccountAttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("attributeValues", attributeValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AccountAttribute
  ) extends zio.aws.ec2.model.AccountAttribute.ReadOnly {
    override val attributeName: Option[String] =
      scala.Option(impl.attributeName()).map(value => value: String)
    override val attributeValues
        : Option[List[zio.aws.ec2.model.AccountAttributeValue.ReadOnly]] = scala
      .Option(impl.attributeValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AccountAttributeValue.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AccountAttribute
  ): zio.aws.ec2.model.AccountAttribute.ReadOnly = new Wrapper(impl)
}
