package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VolumeStatusAction(
    code: Option[String] = None,
    description: Option[String] = None,
    eventId: Option[String] = None,
    eventType: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VolumeStatusAction = {
    import VolumeStatusAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VolumeStatusAction
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(eventId.map(value => value: java.lang.String))(_.eventId)
      .optionallyWith(eventType.map(value => value: java.lang.String))(
        _.eventType
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VolumeStatusAction.ReadOnly =
    zio.aws.ec2.model.VolumeStatusAction.wrap(buildAwsValue())
}
object VolumeStatusAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VolumeStatusAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VolumeStatusAction =
      zio.aws.ec2.model.VolumeStatusAction(
        code.map(value => value),
        description.map(value => value),
        eventId.map(value => value),
        eventType.map(value => value)
      )
    def code: Option[String]
    def description: Option[String]
    def eventId: Option[String]
    def eventType: Option[String]
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEventId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getEventType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventType", eventType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusAction
  ) extends zio.aws.ec2.model.VolumeStatusAction.ReadOnly {
    override val code: Option[String] =
      scala.Option(impl.code()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val eventId: Option[String] =
      scala.Option(impl.eventId()).map(value => value: String)
    override val eventType: Option[String] =
      scala.Option(impl.eventType()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusAction
  ): zio.aws.ec2.model.VolumeStatusAction.ReadOnly = new Wrapper(impl)
}
